/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.backend.pdmc.pda.buchi;

import com.google.common.base.Joiner;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import org.apache.commons.lang3.tuple.Pair;
import org.kframework.backend.pdmc.pda.Configuration;
import org.kframework.backend.pdmc.pda.ConfigurationHead;
import org.kframework.backend.pdmc.pda.PushdownSystemInterface;
import org.kframework.backend.pdmc.pda.Rule;
import org.kframework.backend.pdmc.pda.buchi.BuchiPushdownSystemInterface;
import org.kframework.backend.pdmc.pda.buchi.BuchiState;
import org.kframework.backend.pdmc.pda.buchi.Evaluator;
import org.kframework.backend.pdmc.pda.buchi.PromelaBuchi;

public class BuchiPushdownSystem<Control, Alphabet>
implements BuchiPushdownSystemInterface<Control, Alphabet> {
    private PushdownSystemInterface<Control, Alphabet> pds;
    private PromelaBuchi ba;
    private Evaluator<ConfigurationHead<Control, Alphabet>> atomEvaluator;

    public BuchiPushdownSystem(PushdownSystemInterface<Control, Alphabet> pds, PromelaBuchi ba, Evaluator<ConfigurationHead<Control, Alphabet>> atomEvaluator) {
        this.pds = pds;
        this.ba = ba;
        this.atomEvaluator = atomEvaluator;
    }

    @Override
    public Configuration<Pair<Control, BuchiState>, Alphabet> initialConfiguration() {
        BuchiState buchiInitial = this.ba.initialState();
        Configuration<Control, Alphabet> pdsInitial = this.pds.initialConfiguration();
        ConfigurationHead<Control, Alphabet> pdsHead = pdsInitial.getHead();
        ConfigurationHead<Pair<Control, BuchiState>, Alphabet> initialHead = ConfigurationHead.of(Pair.of(pdsHead.getState(), buchiInitial), pdsHead.getLetter());
        Configuration<ConfigurationHead<Pair<Control, BuchiState>, Alphabet>, Alphabet> initial = new Configuration<ConfigurationHead<Pair<Control, BuchiState>, Alphabet>, Alphabet>(initialHead, pdsInitial.getStack());
        return initial;
    }

    @Override
    public Set<Rule<Pair<Control, BuchiState>, Alphabet>> getRules(ConfigurationHead<Pair<Control, BuchiState>, Alphabet> configurationHead) {
        ConfigurationHead<Control, Alphabet> pdsConfigurationHead = ConfigurationHead.of(configurationHead.getState().getLeft(), configurationHead.getLetter());
        BuchiState buchiState = configurationHead.getState().getRight();
        this.atomEvaluator.setState(pdsConfigurationHead);
        Set<BuchiState> transitions = this.ba.getTransitions(buchiState, this.atomEvaluator);
        Set<Rule<Control, Alphabet>> pdsRules = this.pds.getRules(pdsConfigurationHead);
        HashSet<Rule<Pair<Control, BuchiState>, Alphabet>> rules = new HashSet<Rule<Pair<Control, BuchiState>, Alphabet>>(pdsRules.size());
        for (Rule<Control, Alphabet> pdsRule : pdsRules) {
            for (BuchiState buchiEndState : transitions) {
                Configuration<Control, Alphabet> pdsEndConfig = pdsRule.endConfiguration();
                ConfigurationHead<Control, Alphabet> pdsEndConfigHead = pdsEndConfig.getHead();
                Pair<Control, BuchiState> endState = Pair.of(pdsEndConfigHead.getState(), buchiEndState);
                ConfigurationHead<Pair<Control, BuchiState>, Alphabet> endHead = ConfigurationHead.of(endState, pdsEndConfigHead.getLetter());
                Configuration<ConfigurationHead<Pair<Control, BuchiState>, Alphabet>, Alphabet> endConfiguration = new Configuration<ConfigurationHead<Pair<Control, BuchiState>, Alphabet>, Alphabet>(endHead, pdsEndConfig.getStack());
                rules.add(new Rule<ConfigurationHead<Pair<Control, BuchiState>, Alphabet>, Alphabet>(configurationHead, endConfiguration));
            }
        }
        return rules;
    }

    @Override
    public boolean isFinal(Pair<Control, BuchiState> state) {
        return state.getRight().isFinal();
    }

    public String toString() {
        Configuration<Pair<Control, BuchiState>, Alphabet> cfg = this.initialConfiguration();
        StringBuilder result = new StringBuilder();
        result.append("Initial Configuration: ");
        result.append(cfg.toString());
        result.append("\n");
        HashSet<Pair<Control, BuchiState>> states = new HashSet<Pair<Control, BuchiState>>();
        HashSet<Object> letters = new HashSet<Object>();
        Stack<ConfigurationHead<Pair<Object, BuchiState>, Object>> toBeProcessed = new Stack<ConfigurationHead<Pair<Object, BuchiState>, Object>>();
        toBeProcessed.push(cfg.getHead());
        states.add(cfg.getHead().getState());
        letters.add(cfg.getHead().getLetter());
        Joiner joiner = Joiner.on(";\n");
        while (!toBeProcessed.empty()) {
            ConfigurationHead head = (ConfigurationHead)toBeProcessed.pop();
            Set<Rule<Pair<Control, BuchiState>, Alphabet>> rules = this.getRules(head);
            if (rules.isEmpty()) continue;
            joiner.appendTo(result, (Iterable<?>)rules);
            result.append("\n");
            for (Rule<Pair<Control, BuchiState>, Alphabet> rule : rules) {
                cfg = rule.endConfiguration();
                Stack<Alphabet> newstack = new Stack<Alphabet>();
                newstack.addAll(cfg.getStack());
                if (cfg.getHead().isProper()) {
                    newstack.add(cfg.getHead().getLetter());
                }
                for (Object l : newstack) {
                    if (letters.contains(l)) continue;
                    letters.add(l);
                    for (Pair pair : states) {
                        toBeProcessed.push(ConfigurationHead.of(pair, l));
                    }
                }
                Pair<Control, BuchiState> state = cfg.getHead().getState();
                if (states.contains(state)) continue;
                states.add(state);
                for (Object e : letters) {
                    toBeProcessed.push(ConfigurationHead.of(state, e));
                }
            }
        }
        return result.toString();
    }
}

