/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.backend.pdmc.pda.buchi;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.apache.commons.lang3.tuple.Pair;
import org.kframework.backend.pdmc.automaton.Transition;
import org.kframework.backend.pdmc.pda.Configuration;
import org.kframework.backend.pdmc.pda.ConfigurationHead;
import org.kframework.backend.pdmc.pda.Rule;
import org.kframework.backend.pdmc.pda.buchi.BuchiPushdownSystemInterface;
import org.kframework.backend.pdmc.pda.buchi.BuchiState;
import org.kframework.backend.pdmc.pda.graph.TarjanSCC;
import org.kframework.backend.pdmc.pda.pautomaton.PAutomaton;
import org.kframework.backend.pdmc.pda.pautomaton.PAutomatonState;
import org.kframework.backend.pdmc.pda.pautomaton.util.IndexedTransitions;

public class BuchiPushdownSystemTools<Control, Alphabet> {
    BuchiPushdownSystemInterface<Control, Alphabet> bps;
    private PAutomaton<PAutomatonState<Pair<Control, BuchiState>, Alphabet>, LabelledAlphabet<Control, Alphabet>> postStar = null;
    TarjanSCC<ConfigurationHead<Pair<Control, BuchiState>, Alphabet>, Boolean> repeatedHeadsGraph = null;

    public BuchiPushdownSystemTools(BuchiPushdownSystemInterface<Control, Alphabet> bps) {
        this.bps = bps;
    }

    public PAutomaton<PAutomatonState<Pair<Control, BuchiState>, Alphabet>, LabelledAlphabet<Control, Alphabet>> getPostStar() {
        if (this.postStar == null) {
            this.compute();
        }
        return this.postStar;
    }

    public TarjanSCC<ConfigurationHead<Pair<Control, BuchiState>, Alphabet>, Boolean> getRepeatedHeadsGraph() {
        if (this.repeatedHeadsGraph == null) {
            this.compute();
        }
        return this.repeatedHeadsGraph;
    }

    private void compute() {
        EpsilonTransitionWatch watch = new EpsilonTransitionWatch();
        HashSet trans = new HashSet();
        IndexedTransitions rel = new IndexedTransitions<PAutomatonState<Pair<Control, BuchiState>, Alphabet>, LabelledAlphabet<Control, Alphabet>>(){

            @Override
            public boolean isEpsilon(LabelledAlphabet<Control, Alphabet> gamma) {
                return gamma == null || gamma.getLeft() == null;
            }
        };
        this.repeatedHeadsGraph = new TarjanSCC();
        Configuration initial = this.bps.initialConfiguration();
        ConfigurationHead initialHead = initial.getHead();
        PAutomatonState initialState = PAutomatonState.of(initialHead.getState());
        assert (initial.getStack().isEmpty()) : "Only one element in the initial stack accepted at the moment";
        PAutomatonState finalState = PAutomatonState.of(initialHead.getState(), initialHead.getLetter());
        trans.add(Transition.of(initialState, LabelledAlphabet.of(initialHead.getLetter(), false), finalState));
        while (!trans.isEmpty()) {
            Iterator iterator = trans.iterator();
            Transition transition = (Transition)iterator.next();
            iterator.remove();
            if (((LabelledAlphabet)transition.getLetter()).getLeft() == null) {
                for (Pair pair : watch.get((PAutomatonState)transition.getEnd())) {
                    ConfigurationHead endV = ConfigurationHead.of(((PAutomatonState)transition.getStart()).getState(), pair.getRight().letter);
                    this.repeatedHeadsGraph.addEdge(pair.getLeft(), endV, ((LabelledAlphabet)transition.getLetter()).isRepeated());
                }
            }
            if (rel.contains(transition)) continue;
            rel.add(transition);
            LabelledAlphabet letter = (LabelledAlphabet)transition.getLetter();
            Object gamma = letter.getLeft();
            boolean b = letter.isRepeated();
            PAutomatonState tp = (PAutomatonState)transition.getStart();
            PAutomatonState q = (PAutomatonState)transition.getEnd();
            if (gamma != null) {
                assert (tp.getLetter() == null) : "Expecting PDS state on the lhs of " + transition;
                Pair p = (Pair)tp.getState();
                ConfigurationHead configurationHead = ConfigurationHead.of(p, gamma);
                Set rules = this.bps.getRules(configurationHead);
                for (Rule rule : rules) {
                    Pair pPrime = rule.endState();
                    Stack stack = rule.endStack();
                    assert (stack.size() <= 2) : "At most 2 elements are allowed in the stack for now";
                    switch (stack.size()) {
                        case 0: {
                            LabelledAlphabet labelledLetter = LabelledAlphabet.of(null, b || this.bps.isFinal(pPrime));
                            labelledLetter.setRule(rule);
                            trans.add(Transition.of(PAutomatonState.of(pPrime), labelledLetter, q));
                            break;
                        }
                        case 1: {
                            Object gamma1 = stack.peek();
                            this.repeatedHeadsGraph.addEdge(configurationHead, rule.endConfiguration().getHead(), this.bps.isFinal(p));
                            LabelledAlphabet labelledLetter = LabelledAlphabet.of(gamma1, b || this.bps.isFinal(pPrime));
                            labelledLetter.setRule(rule);
                            trans.add(Transition.of(PAutomatonState.of(pPrime), labelledLetter, q));
                            break;
                        }
                        case 2: {
                            Object gamma1 = stack.get(1);
                            this.repeatedHeadsGraph.addEdge(configurationHead, rule.endConfiguration().getHead(), this.bps.isFinal(p));
                            Object gamma2 = stack.get(0);
                            PAutomatonState qPPrimeGamma1 = PAutomatonState.of(pPrime, gamma1);
                            LabelledAlphabet labelledLetter = LabelledAlphabet.of(gamma1, b || this.bps.isFinal(pPrime));
                            labelledLetter.setRule(rule);
                            trans.add(Transition.of(PAutomatonState.of(pPrime), labelledLetter, qPPrimeGamma1));
                            labelledLetter = LabelledAlphabet.of(gamma2, false);
                            labelledLetter.setRule(rule);
                            rel.add(Transition.of(qPPrimeGamma1, labelledLetter, q));
                            for (Transition t : rel.getBackEpsilonTransitions(qPPrimeGamma1)) {
                                labelledLetter = LabelledAlphabet.of(gamma2, ((LabelledAlphabet)t.getLetter()).isRepeated());
                                labelledLetter.setRule(rule);
                                labelledLetter.setBackState(qPPrimeGamma1);
                                trans.add(Transition.of(t.getStart(), labelledLetter, q));
                                ConfigurationHead endV = ConfigurationHead.of(t.getStart().getState(), gamma2);
                                this.repeatedHeadsGraph.addEdge(configurationHead, endV, ((LabelledAlphabet)t.getLetter()).isRepeated());
                            }
                            watch.addWatch(qPPrimeGamma1, configurationHead, gamma2, rule);
                        }
                    }
                }
                continue;
            }
            for (Transition t : rel.getFrontTransitions(q)) {
                LabelledAlphabet tLetter = (LabelledAlphabet)t.getLetter();
                LabelledAlphabet labelledLetter = LabelledAlphabet.of(tLetter.getLeft(), tLetter.isRepeated() || b);
                labelledLetter.setBackState(q);
                trans.add(Transition.of(tp, labelledLetter, t.getEnd()));
            }
        }
        this.postStar = new PAutomaton(rel.getTransitions(), initialState, Collections.singleton(finalState));
    }

    class EpsilonTransitionWatch {
        Map<PAutomatonState<Pair<Control, BuchiState>, Alphabet>, Set<Pair<ConfigurationHead<Pair<Control, BuchiState>, Alphabet>, LabelledAlphabet<Control, Alphabet>>>> transitionsWatchMap = new HashMap();

        EpsilonTransitionWatch() {
        }

        Set<Pair<ConfigurationHead<Pair<Control, BuchiState>, Alphabet>, LabelledAlphabet<Control, Alphabet>>> get(PAutomatonState<Pair<Control, BuchiState>, Alphabet> key) {
            Set set = this.transitionsWatchMap.get(key);
            if (set == null) {
                set = Collections.emptySet();
            }
            return set;
        }

        void addWatch(PAutomatonState<Pair<Control, BuchiState>, Alphabet> key, ConfigurationHead<Pair<Control, BuchiState>, Alphabet> startHead, Alphabet endLetter, Rule<Pair<Control, BuchiState>, Alphabet> rule) {
            Set set = this.transitionsWatchMap.get(key);
            if (set == null) {
                set = new HashSet();
                this.transitionsWatchMap.put(key, set);
            }
            LabelledAlphabet labelledLetter = LabelledAlphabet.of(endLetter, false);
            labelledLetter.setBackState(key);
            labelledLetter.setRule(rule);
            set.add(Pair.of(startHead, labelledLetter));
        }
    }

    static class LabelledAlphabet<Control, Alphabet> {
        Alphabet letter;
        boolean repeated;
        Rule<Pair<Control, BuchiState>, Alphabet> rule;
        PAutomatonState<Pair<Control, BuchiState>, Alphabet> backState;

        public Rule<Pair<Control, BuchiState>, Alphabet> getRule() {
            return this.rule;
        }

        public void setRule(Rule<Pair<Control, BuchiState>, Alphabet> rule) {
            this.rule = rule;
        }

        public PAutomatonState<Pair<Control, BuchiState>, Alphabet> getBackState() {
            return this.backState;
        }

        public void setBackState(PAutomatonState<Pair<Control, BuchiState>, Alphabet> backState) {
            this.backState = backState;
        }

        LabelledAlphabet(Alphabet letter, boolean repeated) {
            this.letter = letter;
            this.repeated = repeated;
            this.rule = null;
            this.backState = null;
        }

        public static <Control, Alphabet> LabelledAlphabet<Control, Alphabet> of(Alphabet letter, boolean repeated) {
            return new LabelledAlphabet<Control, Alphabet>(letter, repeated);
        }

        public Alphabet getLeft() {
            return this.letter;
        }

        public boolean isRepeated() {
            return this.repeated;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LabelledAlphabet that = (LabelledAlphabet)o;
            if (this.repeated != that.repeated) {
                return false;
            }
            return !(this.letter != null ? !this.letter.equals(that.letter) : that.letter != null);
        }

        public int hashCode() {
            int result = this.letter != null ? this.letter.hashCode() : 0;
            result = 31 * result + (this.repeated ? 1 : 0);
            return result;
        }

        public String toString() {
            return "<" + this.letter + ", " + this.repeated + '>';
        }
    }
}

