/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.backend.pdmc.pda.buchi;

import java.util.HashMap;
import java.util.Map;
import org.kframework.backend.pdmc.pda.buchi.parser.Token;

public class BuchiState {
    public static final String ACCEPT = "accept";
    public static final String INIT = "init";
    static final Map<String, BuchiState> cache = new HashMap<String, BuchiState>();
    String left;
    String right;

    private BuchiState(String s, String s1) {
        this.left = s;
        this.right = s1;
        if (this.left.equals(ACCEPT)) {
            this.left = ACCEPT;
        }
        if (this.right.equals(INIT)) {
            this.right = INIT;
        }
    }

    public boolean isFinal() {
        return this.left == ACCEPT;
    }

    public boolean isStart() {
        return this.right == INIT;
    }

    public String toString() {
        return this.left + "_" + this.right;
    }

    public static BuchiState of(Token id) {
        String[] two = id.image.split("_");
        assert (two.length == 2) : "Each state should have two parts";
        BuchiState state = cache.get(id.image);
        if (state == null) {
            state = new BuchiState(two[0], two[1]);
            cache.put(id.image, state);
        }
        return state;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BuchiState that = (BuchiState)o;
        if (!this.left.equals(that.left)) {
            return false;
        }
        return this.right.equals(that.right);
    }

    public int hashCode() {
        int result = this.left.hashCode();
        result = 31 * result + this.right.hashCode();
        return result;
    }
}

