/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.backend.pdmc.pda.buchi;

import com.google.common.base.Joiner;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.kframework.backend.pdmc.pda.Configuration;
import org.kframework.backend.pdmc.pda.ConfigurationHead;
import org.kframework.backend.pdmc.pda.buchi.Evaluator;
import org.kframework.backend.pdmc.pda.buchi.Identifier;

public class ConcreteEvaluator<Control, Alphabet>
implements Evaluator<ConfigurationHead<Control, Alphabet>> {
    Map<ConfigurationHead<Control, Alphabet>, Set<String>> evaluationMap;
    Set<String> currentAtoms = null;

    public ConcreteEvaluator(Map<ConfigurationHead<Control, Alphabet>, Set<String>> evaluationMap) {
        this.evaluationMap = evaluationMap;
    }

    @Override
    public boolean evaluate(Identifier id) {
        return this.currentAtoms.contains(id.name);
    }

    @Override
    public void setState(ConfigurationHead<Control, Alphabet> controlAlphabetConfigurationHead) {
        this.currentAtoms = this.evaluationMap.get(controlAlphabetConfigurationHead);
        if (null == this.currentAtoms) {
            this.currentAtoms = Collections.emptySet();
        }
    }

    public static ConcreteEvaluator<String, String> of(String s) {
        String[] stringSats;
        HashMap evaluationMap = new HashMap();
        for (String stringSat : stringSats = s.split("\\s*;\\s*")) {
            String[] stateAndAtoms = stringSat.split("\\s*\\|=\\s*");
            assert (stateAndAtoms.length == 2) : "state |= atoms";
            Configuration<String, String> cfg = Configuration.of(stateAndAtoms[0]);
            assert (cfg.getStack().empty()) : "Should be a configuration head.";
            String[] stringAtoms = stateAndAtoms[1].split("\\s+");
            HashSet<String> atoms = new HashSet<String>();
            for (String stringAtom : stringAtoms) {
                atoms.add(stringAtom);
            }
            evaluationMap.put(cfg.getHead(), atoms);
        }
        return new ConcreteEvaluator<String, String>(evaluationMap);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<ConfigurationHead<Control, Alphabet>, Set<String>> entry : this.evaluationMap.entrySet()) {
            stringBuilder.append(entry.getKey().toString());
            stringBuilder.append(" |= ");
            Joiner joiner = Joiner.on(' ');
            joiner.appendTo(stringBuilder, (Iterable)entry.getValue());
            stringBuilder.append(";\n");
        }
        return stringBuilder.toString();
    }
}

