/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.backend.pdmc.pda.buchi;

import com.google.common.base.Joiner;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.kframework.backend.pdmc.pda.buchi.BuchiState;
import org.kframework.backend.pdmc.pda.buchi.Evaluator;
import org.kframework.backend.pdmc.pda.buchi.PromelaTransition;

public class PromelaBuchi {
    BuchiState initialState;
    private Map<BuchiState, Collection<PromelaTransition>> transitionMap = new HashMap<BuchiState, Collection<PromelaTransition>>();

    public void addTransitions(BuchiState start, Collection<PromelaTransition> transitions) {
        assert (!this.transitionMap.containsKey(start)) : "Duplicate state label";
        this.transitionMap.put(start, transitions);
        if (start.isStart()) {
            this.initialState = start;
        }
    }

    public BuchiState initialState() {
        return this.initialState;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("never {\n");
        boolean first = true;
        for (Map.Entry<BuchiState, Collection<PromelaTransition>> entry : this.transitionMap.entrySet()) {
            if (first) {
                first = false;
            } else {
                result.append(";\n");
            }
            result.append(entry.getKey() + " :\n");
            Collection<PromelaTransition> cases = entry.getValue();
            if (cases.isEmpty()) {
                result.append("\tskip");
                continue;
            }
            result.append("\tif\n\t");
            Joiner.on("\n\t").appendTo(result, (Iterable<?>)cases);
            result.append("\n\tfi");
        }
        result.append("\n}\n");
        return result.toString();
    }

    public Set<BuchiState> getTransitions(BuchiState buchiState, Evaluator atomEvaluator) {
        Collection<PromelaTransition> transitions = this.transitionMap.get(buchiState);
        if (transitions == null) {
            return Collections.emptySet();
        }
        HashSet<BuchiState> states = new HashSet<BuchiState>();
        for (PromelaTransition transition : transitions) {
            if (!transition.getCondition().evaluate(atomEvaluator)) continue;
            states.add(transition.getState());
        }
        if (states.isEmpty()) {
            return Collections.emptySet();
        }
        return states;
    }
}

