/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.backend.pdmc.pda.graph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Stack;

public class TarjanSCC<Data, Label> {
    Map<Data, TarjanSCCVertex> vertexSet = new HashMap<Data, TarjanSCCVertex>();
    Map<Data, Map<Data, Label>> edgeSet = new HashMap<Data, Map<Data, Label>>();
    Collection<Collection<TarjanSCCVertex>> sccs = null;
    int index;
    Stack<TarjanSCCVertex> sccStack;

    public boolean addEdge(Data data1, Data data2, Label l) {
        Object ll;
        TarjanSCCVertex vertex2;
        TarjanSCCVertex vertex1 = this.vertexSet.get(data1);
        if (vertex1 == null) {
            vertex1 = new TarjanSCCVertex(data1);
            this.vertexSet.put(data1, vertex1);
        }
        if ((vertex2 = this.vertexSet.get(data2)) == null) {
            vertex2 = new TarjanSCCVertex(data2);
            this.vertexSet.put(data2, vertex2);
        }
        return !l.equals(ll = vertex1.nextVertex.put(data2, l));
    }

    public Collection<Collection<TarjanSCCVertex>> stronglyConnectedComponents() {
        if (this.sccs == null) {
            this.computeSCC();
        }
        return this.sccs;
    }

    private void computeSCC() {
        this.index = 0;
        this.sccs = new ArrayList<Collection<TarjanSCCVertex>>();
        this.sccStack = new Stack();
        for (TarjanSCCVertex v : this.vertexSet.values()) {
            if (v.index != -1) continue;
            this.strongConnect(v);
        }
    }

    private void strongConnect(TarjanSCCVertex v) {
        v.index = this.index;
        v.lowlink = this.index++;
        v.inStack = true;
        this.sccStack.push(v);
        for (Object dw : v.nextVertex.keySet()) {
            TarjanSCCVertex w = this.vertexSet.get(dw);
            if (w.index == -1) {
                this.strongConnect(w);
                v.lowlink = Math.min(v.lowlink, w.lowlink);
                continue;
            }
            if (!w.inStack) continue;
            v.lowlink = Math.min(v.lowlink, w.index);
        }
        if (v.lowlink == v.index) {
            HashSet<TarjanSCCVertex> scc = new HashSet<TarjanSCCVertex>();
            TarjanSCCVertex w = null;
            while (w != v) {
                w = this.sccStack.pop();
                w.inStack = false;
                scc.add(w);
            }
            this.sccs.add(scc);
        }
    }

    public String getSCCSString() {
        StringBuilder result = new StringBuilder();
        Collection<Collection<TarjanSCCVertex>> sccs = this.stronglyConnectedComponents();
        for (Collection<TarjanSCCVertex> scc : sccs) {
            result.append("{ ");
            for (TarjanSCCVertex v : scc) {
                result.append(v.toString());
                result.append(" ");
            }
            result.append("}");
            result.append(";\n");
        }
        return result.toString();
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (TarjanSCCVertex vertex : this.vertexSet.values()) {
            if (vertex.nextVertex.isEmpty()) continue;
            result.append(vertex.toString());
            result.append(" |->");
            for (Map.Entry next : vertex.nextVertex.entrySet()) {
                result.append(" (");
                result.append(next.getKey().toString());
                result.append(",");
                result.append(next.getValue().toString());
                result.append(") ;");
            }
            result.append("\n");
        }
        return result.toString();
    }

    public class TarjanSCCVertex {
        Data data;
        Map<Data, Label> nextVertex;
        int index;
        int lowlink;
        boolean inStack;

        TarjanSCCVertex(Data data) {
            this.data = data;
            this.nextVertex = TarjanSCC.this.edgeSet.get(data);
            if (this.nextVertex == null) {
                this.nextVertex = new HashMap();
                TarjanSCC.this.edgeSet.put(data, this.nextVertex);
            }
            this.index = -1;
            this.lowlink = -1;
            this.inStack = false;
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

