/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.backend.pdmc.pda.pautomaton.util;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.kframework.backend.pdmc.automaton.Transition;

public class IndexedTransitions<State, Alphabet> {
    Set<Transition<State, Alphabet>> rel = new HashSet<Transition<State, Alphabet>>();
    Map<State, Set<Transition<State, Alphabet>>> backIndex = new HashMap<State, Set<Transition<State, Alphabet>>>();
    Map<State, Set<Transition<State, Alphabet>>> directIndex = new HashMap<State, Set<Transition<State, Alphabet>>>();

    public boolean contains(Transition<State, Alphabet> transition) {
        return this.rel.contains(transition);
    }

    public Set<Transition<State, Alphabet>> getFrontTransitions(State index) {
        Set<Transition<State, Alphabet>> transitions = this.directIndex.get(index);
        if (transitions == null) {
            transitions = Collections.emptySet();
        }
        return transitions;
    }

    public Set<Transition<State, Alphabet>> getBackEpsilonTransitions(State endState) {
        Set<Transition<State, Alphabet>> transitions = this.backIndex.get(endState);
        if (transitions == null) {
            transitions = Collections.emptySet();
        }
        return transitions;
    }

    public void add(Transition<State, Alphabet> transition) {
        if (this.rel.contains(transition)) {
            return;
        }
        this.rel.add(transition);
        State index = transition.getStart();
        Set<Transition<State, Alphabet>> transitions = this.directIndex.get(index);
        if (transitions == null) {
            transitions = new HashSet<Transition<State, Alphabet>>();
            this.directIndex.put(index, transitions);
        }
        transitions.add(transition);
        if (!this.isEpsilon(transition.getLetter())) {
            return;
        }
        State end = transition.getEnd();
        transitions = this.backIndex.get(end);
        if (transitions == null) {
            transitions = new HashSet<Transition<State, Alphabet>>();
            this.backIndex.put(end, transitions);
        }
        transitions.add(transition);
    }

    public boolean isEpsilon(Alphabet gamma) {
        return gamma == null;
    }

    public Collection<Transition<State, Alphabet>> getTransitions() {
        return this.rel;
    }
}

