/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.backend.symbolic;

import java.util.ArrayList;
import java.util.List;
import org.kframework.kil.ASTNode;
import org.kframework.kil.Bag;
import org.kframework.kil.BoolBuiltin;
import org.kframework.kil.Cell;
import org.kframework.kil.Configuration;
import org.kframework.kil.Module;
import org.kframework.kil.PriorityBlock;
import org.kframework.kil.Production;
import org.kframework.kil.ProductionItem;
import org.kframework.kil.Sort;
import org.kframework.kil.Syntax;
import org.kframework.kil.Term;
import org.kframework.kil.Terminal;
import org.kframework.kil.Variable;
import org.kframework.kil.loader.Context;
import org.kframework.kil.visitors.CopyOnWriteTransformer;
import org.kframework.kil.visitors.exceptions.TransformerException;
import org.kframework.utils.errorsystem.KException;
import org.kframework.utils.general.GlobalSettings;

public class AddConditionToConfig
extends CopyOnWriteTransformer {
    public static String KCELL = "k";
    public static boolean PC = true;
    public static String PC_VAR = "$PC";

    public AddConditionToConfig(Context context) {
        super("Add path condition to configuration", context);
    }

    @Override
    public ASTNode transform(Configuration node) throws TransformerException {
        Cell topCell;
        Cell cell = new Cell();
        cell.setLabel("path-condition");
        cell.setEllipses(Cell.Ellipses.NONE);
        if (PC) {
            Variable pc = new Variable(PC_VAR, "Bool");
            cell.setContents(pc);
            this.context.configVarSorts.put(pc.getName(), pc.getSort());
        } else {
            cell.setContents(BoolBuiltin.TRUE);
        }
        Term body = node.getBody();
        if (body instanceof Cell && (topCell = (Cell)body).getLabel().equals("generatedTop")) {
            node = node.shallowCopy();
            node.setBody(AddConditionToConfig.addSubcellToCell(topCell, cell));
            return node;
        }
        return node;
    }

    public static Cell addSubcellToCell(Cell pCell, Cell cCell) {
        if (pCell == null || cCell == null) {
            return null;
        }
        Term cont = pCell.getContents();
        if (cont instanceof Bag) {
            Bag conts = (Bag)cont;
            ArrayList<Term> contents = new ArrayList<Term>();
            contents.addAll(conts.getContents());
            contents.add(cCell);
            pCell = pCell.shallowCopy();
            pCell.setContents(new Bag(contents));
        } else if (cont instanceof Cell) {
            Cell conts = (Cell)cont;
            ArrayList<Term> contents = new ArrayList<Term>();
            contents.add(conts);
            contents.add(cCell);
            pCell = pCell.shallowCopy();
            pCell.setContents(new Bag(contents));
        }
        return pCell;
    }

    public static boolean addCellNextToKCell(Cell cell, Cell toAdd) {
        List<Term> subCells;
        Term contents = cell.getContents();
        if (contents instanceof Bag) {
            Bag content = (Bag)contents;
            subCells = content.getContents();
            for (Term subCell : subCells) {
                if (!(subCell instanceof Cell) || !((Cell)subCell).getLabel().equals(KCELL)) continue;
                subCells.add(toAdd);
                cell = cell.shallowCopy();
                cell.setContents(new Bag(subCells));
                return true;
            }
            for (Term subCell : subCells) {
                boolean added;
                if (!(subCell instanceof Cell) || !(added = AddConditionToConfig.addCellNextToKCell((Cell)subCell, toAdd))) continue;
                return true;
            }
        }
        if (contents instanceof Cell) {
            Cell subCell = (Cell)contents;
            if (subCell.getLabel().equals(KCELL)) {
                subCells = new ArrayList<Term>();
                subCells.add(subCell);
                subCells.add(toAdd);
                cell = cell.shallowCopy();
                cell.setContents(new Bag(subCells));
                return true;
            }
            boolean added = AddConditionToConfig.addCellNextToKCell(subCell, toAdd);
            if (added) {
                return true;
            }
        }
        return false;
    }

    @Override
    public ASTNode transform(Module node) throws TransformerException {
        ASTNode result = super.transform(node);
        if (result == node) {
            return node;
        }
        if (result == null) {
            GlobalSettings.kem.register(new KException(KException.ExceptionType.ERROR, KException.KExceptionGroup.COMPILER, "Expecting Module, but got null. Returning the untransformed module.", this.getName(), node.getFilename(), node.getLocation()));
            return node;
        }
        if (!(result instanceof Module)) {
            GlobalSettings.kem.register(new KException(KException.ExceptionType.ERROR, KException.KExceptionGroup.INTERNAL, "Expecting Module, but got " + result.getClass() + " while transforming.", node.getFilename(), node.getLocation()));
            return node;
        }
        node = (Module)result;
        ArrayList<PriorityBlock> topCellBlocks = new ArrayList<PriorityBlock>();
        PriorityBlock topPriorityBlock = new PriorityBlock();
        ArrayList<ProductionItem> topTerminals = new ArrayList<ProductionItem>();
        topTerminals.add(new Terminal("path-condition"));
        Production topProduction = new Production(new Sort("CellLabel"), topTerminals);
        topPriorityBlock.getProductions().add(topProduction);
        topCellBlocks.add(topPriorityBlock);
        Syntax topCellDecl = new Syntax(new Sort("CellLabel"), topCellBlocks);
        node.getItems().add(topCellDecl);
        return node;
    }
}

