/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.backend.symbolic;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.kframework.backend.symbolic.AddConditionToConfig;
import org.kframework.backend.symbolic.CollapseAndBoolTransformer;
import org.kframework.backend.symbolic.ConditionTransformer;
import org.kframework.backend.symbolic.SymbolicBackend;
import org.kframework.kil.ASTNode;
import org.kframework.kil.Attribute;
import org.kframework.kil.Attributes;
import org.kframework.kil.Cell;
import org.kframework.kil.KApp;
import org.kframework.kil.KLabelConstant;
import org.kframework.kil.KList;
import org.kframework.kil.Rewrite;
import org.kframework.kil.Rule;
import org.kframework.kil.StringBuiltin;
import org.kframework.kil.Term;
import org.kframework.kil.Variable;
import org.kframework.kil.loader.Context;
import org.kframework.kil.visitors.CopyOnWriteTransformer;
import org.kframework.kil.visitors.exceptions.TransformerException;
import org.kframework.utils.general.GlobalSettings;

public class AddPathCondition
extends CopyOnWriteTransformer {
    public AddPathCondition(Context context) {
        super("Add Path Condition to each rule", context);
    }

    @Override
    public ASTNode transform(Rule node) throws TransformerException {
        if (!node.containsAttribute(SymbolicBackend.SYMBOLIC)) {
            return node;
        }
        if (node.getRequires() == null) {
            return node;
        }
        Term condition = node.getRequires();
        CollapseAndBoolTransformer cnft = new CollapseAndBoolTransformer(this.context);
        condition = (Term)node.getRequires().accept(cnft);
        ConditionTransformer ct = new ConditionTransformer(this.context);
        condition = (Term)condition.accept(ct);
        if (node.getBody() instanceof Rewrite) {
            Rewrite rew = (Rewrite)node.getBody();
            Variable phi = Variable.getFreshVar("K");
            Cell leftCell = new Cell();
            leftCell.setLabel("path-condition");
            leftCell.setEllipses(Cell.Ellipses.NONE);
            leftCell.setContents(phi);
            Term left = rew.getLeft();
            if (left instanceof Cell) {
                left = AddConditionToConfig.addSubcellToCell((Cell)left, leftCell);
            }
            Term right = rew.getRight();
            Cell rightCell = new Cell();
            rightCell.setLabel("path-condition");
            rightCell.setEllipses(Cell.Ellipses.NONE);
            Term pathCondition = phi;
            if (!ct.getFilteredTerms().isEmpty()) {
                ArrayList<Term> list = new ArrayList<Term>();
                list.add(phi);
                list.add(AddPathCondition.andBool(ct.getFilteredTerms()));
                pathCondition = new KApp(KLabelConstant.BOOL_ANDBOOL_KLABEL, new KList(list));
            }
            rightCell.setContents(pathCondition);
            if (right instanceof Cell) {
                right = AddConditionToConfig.addSubcellToCell((Cell)right, rightCell);
            }
            Attributes atts = node.getAttributes();
            Term cond = condition;
            if (!GlobalSettings.NOSMT) {
                ArrayList<Term> myList = new ArrayList<Term>();
                myList.add(condition);
                myList.add(AddPathCondition.checkSat(pathCondition, this.context));
                if (!(pathCondition instanceof Variable)) {
                    cond = new KApp(KLabelConstant.ANDBOOL_KLABEL, new KList(myList));
                    List<Attribute> attrs = node.getAttributes().getContents();
                    attrs.add(new Attribute("transition", ""));
                    atts = node.getAttributes().shallowCopy();
                    atts.setContents(attrs);
                }
            }
            node = node.shallowCopy();
            node.setBody(new Rewrite(left, right, this.context));
            node.setAttributes(atts);
            node.setRequires(cond);
        }
        return node;
    }

    public static Term andBool(List<Term> filteredTerms) {
        Iterator<Term> it = filteredTerms.iterator();
        Term and = it.next();
        while (it.hasNext()) {
            ArrayList<Term> list = new ArrayList<Term>();
            list.add(and);
            list.add(it.next());
            and = new KApp(KLabelConstant.BOOL_ANDBOOL_KLABEL, new KList(list));
        }
        return and;
    }

    public static Term checkSat(Term pathCondition, Context context) {
        KApp unsat = StringBuiltin.kAppOf("unsat");
        KApp checkSat = KApp.of(KLabelConstant.of("'checkSat", context), pathCondition);
        return KApp.of(KLabelConstant.KNEQ_KLABEL, checkSat, unsat);
    }
}

