/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.backend.symbolic;

import java.util.ArrayList;
import org.kframework.backend.symbolic.AddConditionToConfig;
import org.kframework.backend.symbolic.EliminateRRWrapper;
import org.kframework.kil.ASTNode;
import org.kframework.kil.Cell;
import org.kframework.kil.KApp;
import org.kframework.kil.KLabelConstant;
import org.kframework.kil.KList;
import org.kframework.kil.Rewrite;
import org.kframework.kil.Rule;
import org.kframework.kil.Sentence;
import org.kframework.kil.StringBuiltin;
import org.kframework.kil.Term;
import org.kframework.kil.Variable;
import org.kframework.kil.loader.Context;
import org.kframework.kil.visitors.CopyOnWriteTransformer;
import org.kframework.kil.visitors.exceptions.TransformerException;

public class AddPathConditionToReachabilityKRule
extends CopyOnWriteTransformer {
    public AddPathConditionToReachabilityKRule(Context context) {
        super("Add path condition to reachability rule represented as K rule", context);
    }

    @Override
    public ASTNode transform(Rule node) throws TransformerException {
        if (!node.containsAttribute("reachability-formula")) {
            return node;
        }
        if (node.getBody() instanceof Rewrite) {
            Rewrite body = (Rewrite)node.getBody();
            Term lcfg = body.getLeft().shallowCopy();
            Term rcfg = body.getRight().shallowCopy();
            Term condition = node.getRequires();
            if (condition instanceof KApp) {
                KApp appCondition = (KApp)condition;
                EliminateRRWrapper errw = new EliminateRRWrapper(this.context);
                Term newCond = (Term)appCondition.accept(errw);
                Term lphi = errw.getLphi();
                Term rphi = errw.getRphi();
                Variable pc = Variable.getFreshVar("K");
                Term leftBag = this.addPathCondition(lcfg, pc);
                ArrayList<Term> pcAndPhi = new ArrayList<Term>();
                pcAndPhi.add(pc);
                pcAndPhi.add(rphi);
                KApp pcNew = new KApp(KLabelConstant.BOOL_ANDBOOL_KLABEL, new KList(pcAndPhi));
                Term rightBag = this.addPathCondition(rcfg, pcNew);
                KApp sat = StringBuiltin.kAppOf("sat");
                KApp checkSat = KApp.of(KLabelConstant.of("'checkSat", this.context), KApp.of(KLabelConstant.BOOL_ANDBOOL_KLABEL, pc, lphi));
                KApp newCondition = KApp.of(KLabelConstant.KEQ_KLABEL, checkSat, sat);
                newCondition = KApp.of(KLabelConstant.BOOL_ANDBOOL_KLABEL, newCondition, newCond);
                Sentence rule = new Sentence();
                rule.setBody(new Rewrite(leftBag, rightBag, this.context));
                Rule newRule = new Rule(rule);
                newRule.setRequires(newCondition);
                newRule.setAttributes(node.getAttributes().shallowCopy());
                return newRule;
            }
        }
        return node;
    }

    private Term addPathCondition(Term cfg, Term pcContent) {
        Cell pcCell = new Cell();
        pcCell.setLabel("path-condition");
        pcCell.setEllipses(Cell.Ellipses.NONE);
        pcCell.setContents(pcContent);
        return AddConditionToConfig.addSubcellToCell((Cell)cfg, pcCell);
    }
}

