/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.backend.symbolic;

import java.util.ArrayList;
import java.util.List;
import org.kframework.kil.ASTNode;
import org.kframework.kil.KApp;
import org.kframework.kil.KLabelConstant;
import org.kframework.kil.KList;
import org.kframework.kil.Term;
import org.kframework.kil.loader.Context;
import org.kframework.kil.visitors.CopyOnWriteTransformer;
import org.kframework.kil.visitors.exceptions.TransformerException;

public class CollapseAndBoolTransformer
extends CopyOnWriteTransformer {
    public CollapseAndBoolTransformer(Context context) {
        super("Collapse nested conjunctions.", context);
    }

    @Override
    public ASTNode transform(KApp node) throws TransformerException {
        return this.recursiveCollapseAndBool(node);
    }

    private KApp recursiveCollapseAndBool(KApp node) {
        Term label = node.getLabel();
        if (label instanceof KLabelConstant) {
            KLabelConstant kLabelConstant = (KLabelConstant)label;
            if (kLabelConstant.equals(KLabelConstant.BOOL_ANDBOOL_KLABEL)) {
                node = node.shallowCopy();
                node.setLabel(KLabelConstant.ANDBOOL_KLABEL);
                return this.recursiveCollapseAndBool(node);
            }
            Term newContent = node.getChild();
            if (kLabelConstant.equals(KLabelConstant.ANDBOOL_KLABEL)) {
                Term aLabel;
                Term content = node.getChild();
                if (content instanceof KList) {
                    List<Term> list = ((KList)content).getContents();
                    ArrayList<Term> newList = new ArrayList<Term>();
                    if (list != null) {
                        for (Term t : list) {
                            KApp tapp;
                            Term tlabel;
                            boolean collapsed = false;
                            if (t instanceof KApp && ((tlabel = (tapp = this.recursiveCollapseAndBool((KApp)t)).getLabel()).equals(KLabelConstant.BOOL_ANDBOOL_KLABEL) || tlabel.equals(KLabelConstant.ANDBOOL_KLABEL))) {
                                Term term = tapp.getChild().shallowCopy();
                                if (term instanceof KList) {
                                    KList listTerm = (KList)term;
                                    List<Term> listContent = listTerm.getContents();
                                    for (Term lt : listContent) {
                                        newList.add(lt);
                                    }
                                } else {
                                    newList.add(tapp.getChild().shallowCopy());
                                }
                                collapsed = true;
                            }
                            if (collapsed) continue;
                            newList.add(t);
                        }
                        newContent = new KList(newList);
                    }
                } else if (content instanceof KApp && ((aLabel = ((KApp)content).getLabel()).equals(KLabelConstant.BOOL_ANDBOOL_KLABEL) || aLabel.equals(KLabelConstant.ANDBOOL_KLABEL))) {
                    KApp resolved = this.recursiveCollapseAndBool((KApp)content);
                    ArrayList<Term> newList = new ArrayList<Term>();
                    newList.add(((Term)resolved).shallowCopy());
                    newContent = new KList(newList);
                }
            }
            return new KApp(node.getLabel(), newContent);
        }
        return node;
    }
}

