/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.backend.symbolic;

import java.util.ArrayList;
import java.util.List;
import org.kframework.backend.symbolic.CheckSmtLibByAddingPredicates;
import org.kframework.kil.ASTNode;
import org.kframework.kil.KApp;
import org.kframework.kil.KLabelConstant;
import org.kframework.kil.KList;
import org.kframework.kil.Term;
import org.kframework.kil.loader.Context;
import org.kframework.kil.visitors.CopyOnWriteTransformer;
import org.kframework.kil.visitors.exceptions.TransformerException;

public class ConditionTransformer
extends CopyOnWriteTransformer {
    List<Term> filteredTerms = new ArrayList<Term>();
    List<Term> generatedPredicates = new ArrayList<Term>();

    public ConditionTransformer(Context context) {
        super("Filter side conditions", context);
    }

    @Override
    public ASTNode transform(KApp node) throws TransformerException {
        Term label = node.getLabel();
        if (label instanceof KLabelConstant) {
            Term content = node.getChild();
            if (label.equals(KLabelConstant.ANDBOOL_KLABEL)) {
                if (content instanceof KList) {
                    List<Term> terms = ((KList)content).getContents();
                    ArrayList<Term> remainingTerms = new ArrayList<Term>();
                    for (Term t : terms) {
                        CheckSmtLibByAddingPredicates csv = new CheckSmtLibByAddingPredicates(this.context);
                        t.accept(csv);
                        if (csv.smtValid()) {
                            this.filteredTerms.add(t.shallowCopy());
                            this.generatedPredicates.addAll(csv.getContents());
                            continue;
                        }
                        remainingTerms.add(t.shallowCopy());
                    }
                    content = new KList(remainingTerms);
                }
            } else {
                CheckSmtLibByAddingPredicates csv = new CheckSmtLibByAddingPredicates(this.context);
                content.accept(csv);
                if (csv.smtValid()) {
                    this.filteredTerms.add(content.shallowCopy());
                    this.generatedPredicates.addAll(csv.getContents());
                    content = new KList();
                }
            }
            node = node.shallowCopy();
            node.setChild(content);
            return node;
        }
        return super.transform(node);
    }

    public List<Term> getFilteredTerms() {
        return this.filteredTerms;
    }

    public List<Term> getGeneratedPredicates() {
        return this.generatedPredicates;
    }
}

