/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.backend.symbolic;

import java.util.ArrayList;
import java.util.Map;
import org.kframework.backend.symbolic.SymbolicBackend;
import org.kframework.backend.symbolic.VariableReplaceTransformer;
import org.kframework.kil.ASTNode;
import org.kframework.kil.KApp;
import org.kframework.kil.KLabelConstant;
import org.kframework.kil.KList;
import org.kframework.kil.Rewrite;
import org.kframework.kil.Rule;
import org.kframework.kil.Term;
import org.kframework.kil.Variable;
import org.kframework.kil.loader.Context;
import org.kframework.kil.visitors.BasicTransformer;
import org.kframework.kil.visitors.exceptions.TransformerException;

public class LineariseTransformer
extends BasicTransformer {
    public LineariseTransformer(Context context) {
        super("Linearise Rules", context);
    }

    @Override
    public ASTNode transform(Rule node) throws TransformerException {
        if (!node.containsAttribute(SymbolicBackend.SYMBOLIC)) {
            return node;
        }
        if (node.getBody() instanceof Rewrite) {
            VariableReplaceTransformer vrt = new VariableReplaceTransformer(this.context);
            Rewrite rew = (Rewrite)node.getBody();
            Term transformedLeft = rew.getLeft();
            transformedLeft = (Term)transformedLeft.accept(vrt);
            rew.shallowCopy();
            rew.setLeft(transformedLeft, this.context);
            Map<Variable, Variable> newGeneratedSV = vrt.getGeneratedVariables();
            Term condition = node.getRequires();
            ArrayList<Term> terms = new ArrayList<Term>();
            for (Map.Entry<Variable, Variable> entry : newGeneratedSV.entrySet()) {
                ArrayList<Term> vars = new ArrayList<Term>();
                vars.add(entry.getKey());
                vars.add(entry.getValue());
                terms.add(new KApp(KLabelConstant.of(KLabelConstant.KEQ.getLabel(), this.context), new KList(vars)));
            }
            if (terms.isEmpty()) {
                return node;
            }
            KApp newCondition = new KApp(KLabelConstant.ANDBOOL_KLABEL, new KList(terms));
            if (condition != null) {
                ArrayList<Term> vars = new ArrayList<Term>();
                vars.add(condition);
                vars.add(newCondition);
                newCondition = new KApp(KLabelConstant.ANDBOOL_KLABEL, new KList(vars));
            }
            node = node.shallowCopy();
            node.setBody(rew);
            node.setRequires(newCondition);
        }
        return node;
    }
}

