/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.backend.symbolic;

import java.util.ArrayList;
import java.util.Map;
import org.kframework.backend.symbolic.ConstantsReplaceTransformer;
import org.kframework.backend.symbolic.SymbolicBackend;
import org.kframework.compile.transformers.AddPredicates;
import org.kframework.kil.ASTNode;
import org.kframework.kil.KApp;
import org.kframework.kil.KLabelConstant;
import org.kframework.kil.KList;
import org.kframework.kil.Rewrite;
import org.kframework.kil.Rule;
import org.kframework.kil.Term;
import org.kframework.kil.Token;
import org.kframework.kil.Variable;
import org.kframework.kil.loader.Context;
import org.kframework.kil.visitors.CopyOnWriteTransformer;
import org.kframework.kil.visitors.exceptions.TransformerException;

public class ReplaceConstants
extends CopyOnWriteTransformer {
    public ReplaceConstants(Context context) {
        super("Replace Constants with Variables", context);
    }

    @Override
    public ASTNode transform(Rule node) throws TransformerException {
        if (!node.containsAttribute(SymbolicBackend.SYMBOLIC)) {
            return node;
        }
        if (node.getBody() instanceof Rewrite) {
            ConstantsReplaceTransformer crt = new ConstantsReplaceTransformer("", this.context);
            Rewrite rew = (Rewrite)node.getBody();
            Term left = rew.getLeft().shallowCopy();
            rew.setLeft((Term)left.accept(crt), this.context);
            Map<Variable, KApp> newGeneratedSV = crt.getGeneratedSV();
            Term condition = node.getRequires();
            ArrayList<Term> terms = new ArrayList<Term>();
            for (Map.Entry<Variable, KApp> entry : newGeneratedSV.entrySet()) {
                ArrayList<Term> vars = new ArrayList<Term>();
                vars.add(entry.getKey());
                vars.add(entry.getValue());
                terms.add(new KApp(KLabelConstant.of(KLabelConstant.KEQ.getLabel(), this.context), new KList(vars)));
                Token token = (Token)entry.getValue().getLabel();
                terms.add(KApp.of(KLabelConstant.of(AddPredicates.predicate(token.tokenSort().replaceFirst("#", "")), this.context), entry.getKey()));
            }
            if (terms.isEmpty()) {
                return node;
            }
            KApp newCondition = new KApp(KLabelConstant.ANDBOOL_KLABEL, new KList(terms));
            if (condition != null) {
                ArrayList<Term> vars = new ArrayList<Term>();
                vars.add(condition);
                vars.add(newCondition);
                newCondition = new KApp(KLabelConstant.ANDBOOL_KLABEL, new KList(vars));
            }
            node = node.shallowCopy();
            node.setBody(rew);
            node.setRequires(newCondition);
        }
        return node;
    }
}

