/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.backend.symbolic;

import java.util.ArrayList;
import java.util.List;
import org.kframework.backend.symbolic.AddPCToBagVariable;
import org.kframework.backend.symbolic.AddPathCondition;
import org.kframework.backend.symbolic.ConditionTransformer;
import org.kframework.kil.ASTNode;
import org.kframework.kil.Bag;
import org.kframework.kil.BoolBuiltin;
import org.kframework.kil.Cell;
import org.kframework.kil.KApp;
import org.kframework.kil.KInjectedLabel;
import org.kframework.kil.KLabelConstant;
import org.kframework.kil.KList;
import org.kframework.kil.Rewrite;
import org.kframework.kil.Rule;
import org.kframework.kil.Term;
import org.kframework.kil.Variable;
import org.kframework.kil.loader.Context;
import org.kframework.kil.visitors.CopyOnWriteTransformer;
import org.kframework.kil.visitors.exceptions.TransformerException;

public class ResolveLtlAttributes
extends CopyOnWriteTransformer {
    private static final String LTL = "ltl";
    private static final String LTL_SAT = "'_|=Ltl_";

    public ResolveLtlAttributes(Context context) {
        super("Resolve LTL attributes", context);
    }

    @Override
    public ASTNode transform(Rule node) throws TransformerException {
        Term body;
        if (node.getAttributes().containsKey(LTL) && (body = node.getBody()) instanceof Rewrite) {
            Rewrite rewrite = (Rewrite)body;
            Term left = rewrite.getLeft();
            Term right = rewrite.getRight();
            Term requires = node.getRequires();
            Term ensures = node.getEnsures();
            Variable phi = Variable.getFreshVar("K");
            Cell pc = new Cell();
            pc.setLabel("path-condition");
            pc.setEllipses(Cell.Ellipses.NONE);
            pc.setContents(phi);
            if (left instanceof KApp) {
                KLabelConstant ltlSatLabel;
                KApp kapp = (KApp)left;
                KList args = (KList)kapp.getChild();
                Term bagVar = args.getContents().get(0);
                Term rest = args.getContents().get(1);
                if (kapp.getLabel() instanceof KLabelConstant && (ltlSatLabel = (KLabelConstant)kapp.getLabel()).getLabel().equals(LTL_SAT)) {
                    Bag bag = new Bag();
                    ArrayList<Term> contents = new ArrayList<Term>();
                    contents.add(bagVar.shallowCopy());
                    contents.add(pc);
                    bag.setContents(contents);
                    String varName = ((Variable)((KInjectedLabel)((KApp)bagVar).getLabel()).getTerm()).getName();
                    bagVar = bag;
                    rest = (Term)rest.accept(new AddPCToBagVariable(this.context, pc, varName));
                    if (requires != null) {
                        requires = (Term)requires.accept(new AddPCToBagVariable(this.context, pc, varName));
                    }
                    if (ensures != null) {
                        ensures = (Term)ensures.accept(new AddPCToBagVariable(this.context, pc, varName));
                    }
                    ConditionTransformer ct = new ConditionTransformer(this.context);
                    Term bSmtInvalid = (Term)requires.accept(ct);
                    List<Term> filtered = ct.getFilteredTerms();
                    filtered.add(BoolBuiltin.TRUE);
                    Term bSmtValid = AddPathCondition.andBool(filtered);
                    Term predicates = AddPathCondition.andBool(ct.getGeneratedPredicates());
                    Term check = AddPathCondition.checkSat(KApp.of(KLabelConstant.BOOL_ANDBOOL_KLABEL, phi, KApp.of(KLabelConstant.NOTBOOL_KLABEL, bSmtValid)), this.context);
                    requires = KApp.of(KLabelConstant.BOOL_ANDBOOL_KLABEL, bSmtInvalid, check);
                    requires = KApp.of(KLabelConstant.BOOL_ANDBOOL_KLABEL, predicates, requires);
                    left = KApp.of(KLabelConstant.of(ltlSatLabel.getLabel()), bagVar, rest);
                    Rule newRule = new Rule(left, right, this.context);
                    newRule.setRequires(requires);
                    newRule.setEnsures(ensures);
                    return newRule;
                }
            }
        }
        return super.transform(node);
    }
}

