/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.backend.symbolic;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import org.kframework.backend.Backend;
import org.kframework.backend.BasicBackend;
import org.kframework.backend.maude.MaudeBackend;
import org.kframework.backend.maude.MaudeBuiltinsFilter;
import org.kframework.backend.symbolic.AddConditionToConfig;
import org.kframework.backend.symbolic.AddPathCondition;
import org.kframework.backend.symbolic.AddPathConditionToReachabilityKRule;
import org.kframework.backend.symbolic.ReachabilityRuleToKRule;
import org.kframework.backend.symbolic.ReplaceConstants;
import org.kframework.backend.symbolic.ResolveLtlAttributes;
import org.kframework.backend.symbolic.ResolveSymbolicInputStream;
import org.kframework.backend.symbolic.TagUserRules;
import org.kframework.backend.unparser.UnparserFilter;
import org.kframework.compile.FlattenModules;
import org.kframework.compile.ResolveConfigurationAbstraction;
import org.kframework.compile.checks.CheckConfigurationCells;
import org.kframework.compile.checks.CheckRewrite;
import org.kframework.compile.checks.CheckVariables;
import org.kframework.compile.sharing.DeclareCellLabels;
import org.kframework.compile.tags.AddDefaultComputational;
import org.kframework.compile.tags.AddOptionalTags;
import org.kframework.compile.tags.AddStrictStar;
import org.kframework.compile.transformers.AddEmptyLists;
import org.kframework.compile.transformers.AddHeatingConditions;
import org.kframework.compile.transformers.AddK2SMTLib;
import org.kframework.compile.transformers.AddKCell;
import org.kframework.compile.transformers.AddKLabelConstant;
import org.kframework.compile.transformers.AddKStringConversion;
import org.kframework.compile.transformers.AddPredicates;
import org.kframework.compile.transformers.AddSemanticEquality;
import org.kframework.compile.transformers.AddSupercoolDefinition;
import org.kframework.compile.transformers.AddSuperheatRules;
import org.kframework.compile.transformers.AddSymbolicK;
import org.kframework.compile.transformers.AddTopCellConfig;
import org.kframework.compile.transformers.AddTopCellRules;
import org.kframework.compile.transformers.ContextsToHeating;
import org.kframework.compile.transformers.DesugarStreams;
import org.kframework.compile.transformers.FlattenSyntax;
import org.kframework.compile.transformers.FreezeUserFreezers;
import org.kframework.compile.transformers.FreshCondToFreshVar;
import org.kframework.compile.transformers.RemoveBrackets;
import org.kframework.compile.transformers.RemoveSyntacticCasts;
import org.kframework.compile.transformers.ResolveAnonymousVariables;
import org.kframework.compile.transformers.ResolveBinder;
import org.kframework.compile.transformers.ResolveBlockingInput;
import org.kframework.compile.transformers.ResolveBuiltins;
import org.kframework.compile.transformers.ResolveFreshVarMOS;
import org.kframework.compile.transformers.ResolveFunctions;
import org.kframework.compile.transformers.ResolveHybrid;
import org.kframework.compile.transformers.ResolveListOfK;
import org.kframework.compile.transformers.ResolveOpenCells;
import org.kframework.compile.transformers.ResolveRewrite;
import org.kframework.compile.transformers.ResolveSupercool;
import org.kframework.compile.transformers.ResolveSyntaxPredicates;
import org.kframework.compile.transformers.StrictnessToContexts;
import org.kframework.compile.utils.CheckVisitorStep;
import org.kframework.compile.utils.CompileDataStructures;
import org.kframework.compile.utils.CompilerSteps;
import org.kframework.compile.utils.InitializeConfigurationStructure;
import org.kframework.kil.Definition;
import org.kframework.kil.loader.Context;
import org.kframework.main.FirstStep;
import org.kframework.utils.Stopwatch;
import org.kframework.utils.file.FileUtil;
import org.kframework.utils.file.KPaths;
import org.kframework.utils.general.GlobalSettings;

public class SymbolicBackend
extends BasicBackend
implements Backend {
    public static String SYMBOLIC = "symbolic-kompile";
    public static String NOTSYMBOLIC = "not-symbolic-kompile";

    public SymbolicBackend(Stopwatch sw, Context context) {
        super(sw, context);
    }

    @Override
    public Definition firstStep(Definition javaDef) {
        String fileSep = System.getProperty("file.separator");
        String propPath = KPaths.getKBase(false) + fileSep + "lib" + fileSep + "maude" + fileSep;
        Properties specialMaudeHooks = new Properties();
        Properties maudeHooks = new Properties();
        try {
            FileUtil.loadProperties(maudeHooks, propPath + "MaudeHooksMap.properties");
            FileUtil.loadProperties(specialMaudeHooks, propPath + "SpecialMaudeHooks.properties");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        MaudeBuiltinsFilter builtinsFilter = new MaudeBuiltinsFilter(maudeHooks, specialMaudeHooks, this.context);
        javaDef.accept(builtinsFilter);
        String mainModule = javaDef.getMainModule();
        StringBuilder builtins = new StringBuilder().append("mod ").append(mainModule).append("-BUILTINS is\n").append(" including ").append(mainModule).append("-BASE .\n").append((CharSequence)builtinsFilter.getResult()).append("endm\n");
        FileUtil.save(this.context.dotk.getAbsolutePath() + "/builtins.maude", builtins);
        this.sw.printIntermediate("Generating equations for hooks");
        return super.firstStep(javaDef);
    }

    @Override
    public void run(Definition javaDef) throws IOException {
        new MaudeBackend(this.sw, this.context).run(javaDef);
        String load = "load \"" + KPaths.getKBase(true) + KPaths.MAUDE_LIB_DIR + "/k-prelude\"\n";
        String maudeLib = GlobalSettings.lib.equals("") ? "" : "load " + KPaths.windowfyPath(new File(GlobalSettings.lib).getAbsolutePath()) + "\n";
        load = load + maudeLib;
        String mainModule = javaDef.getMainModule();
        StringBuilder main = new StringBuilder().append(load).append("load \"base.maude\"\n").append("load \"builtins.maude\"\n").append("mod ").append(mainModule).append(" is \n").append("  including ").append(mainModule).append("-BASE .\n").append("  including ").append(mainModule).append("-BUILTINS .\n").append("endm\n");
        FileUtil.save(this.context.dotk.getAbsolutePath() + "/" + "main.maude", main);
        UnparserFilter unparserFilter = new UnparserFilter(this.context);
        javaDef.accept(unparserFilter);
    }

    @Override
    public String getDefaultStep() {
        return "LastStep";
    }

    @Override
    public CompilerSteps<Definition> getCompilationSteps() {
        CompilerSteps<Definition> steps = new CompilerSteps<Definition>(this.context);
        steps.add(new FirstStep(this, this.context));
        steps.add(new CheckVisitorStep(new CheckConfigurationCells(this.context), this.context));
        steps.add(new RemoveBrackets(this.context));
        steps.add(new AddEmptyLists(this.context));
        steps.add(new RemoveSyntacticCasts(this.context));
        steps.add(new CheckVisitorStep(new CheckVariables(this.context), this.context));
        steps.add(new CheckVisitorStep(new CheckRewrite(this.context), this.context));
        steps.add(new FlattenModules(this.context));
        steps.add(new StrictnessToContexts(this.context));
        steps.add(new FreezeUserFreezers(this.context));
        steps.add(new ContextsToHeating(this.context));
        steps.add(new AddSupercoolDefinition(this.context));
        steps.add(new AddHeatingConditions(this.context));
        steps.add(new AddSuperheatRules(this.context));
        steps.add(new ResolveSymbolicInputStream(this.context));
        steps.add(new DesugarStreams(this.context, false));
        steps.add(new ResolveFunctions(this.context));
        steps.add(new TagUserRules(this.context));
        steps.add(new ReachabilityRuleToKRule(this.context));
        steps.add(new AddKCell(this.context));
        steps.add(new AddSymbolicK(this.context));
        steps.add(new AddSemanticEquality(this.context));
        steps.add(new FreshCondToFreshVar(this.context));
        steps.add(new ResolveFreshVarMOS(this.context));
        steps.add(new AddTopCellConfig(this.context));
        steps.add(new AddConditionToConfig(this.context));
        steps.add(new AddTopCellRules(this.context));
        steps.add(new ResolveBinder(this.context));
        steps.add(new ResolveAnonymousVariables(this.context));
        steps.add(new ResolveBlockingInput(this.context, false));
        steps.add(new AddK2SMTLib(this.context));
        steps.add(new AddPredicates(this.context));
        steps.add(new ResolveSyntaxPredicates(this.context));
        steps.add(new ResolveBuiltins(this.context));
        steps.add(new ResolveListOfK(this.context));
        steps.add(new FlattenSyntax(this.context));
        steps.add(new InitializeConfigurationStructure(this.context));
        steps.add(new AddKStringConversion(this.context));
        steps.add(new AddKLabelConstant(this.context));
        steps.add(new ResolveHybrid(this.context));
        steps.add(new ResolveConfigurationAbstraction(this.context));
        steps.add(new ResolveOpenCells(this.context));
        steps.add(new ResolveRewrite(this.context));
        steps.add(new CompileDataStructures(this.context));
        steps.add(new ReplaceConstants(this.context));
        steps.add(new AddPathCondition(this.context));
        steps.add(new AddPathConditionToReachabilityKRule(this.context));
        steps.add(new ResolveLtlAttributes(this.context));
        steps.add(new ResolveSupercool(this.context));
        steps.add(new AddStrictStar(this.context));
        steps.add(new AddDefaultComputational(this.context));
        steps.add(new AddOptionalTags(this.context));
        steps.add(new DeclareCellLabels(this.context));
        return steps;
    }
}

