/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.backend.symbolic;

import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.kframework.backend.symbolic.SymbolicBackend;
import org.kframework.kil.ASTNode;
import org.kframework.kil.Attribute;
import org.kframework.kil.Attributes;
import org.kframework.kil.Rule;
import org.kframework.kil.loader.Context;
import org.kframework.kil.visitors.CopyOnWriteTransformer;
import org.kframework.kil.visitors.exceptions.TransformerException;
import org.kframework.utils.file.KPaths;
import org.kframework.utils.general.GlobalSettings;

public class TagUserRules
extends CopyOnWriteTransformer {
    public static final Set<String> notSymbolicTags;

    public TagUserRules(Context context) {
        super("Tag rules which are not builtin with 'symbolic' tag", context);
    }

    @Override
    public ASTNode transform(Rule node) throws TransformerException {
        for (String nst : notSymbolicTags) {
            if (!node.containsAttribute(nst)) continue;
            return super.transform(node);
        }
        if (!node.getFilename().startsWith(KPaths.getKBase(false) + File.separator + "include") && !node.getFilename().startsWith("File System") || GlobalSettings.javaBackend && node.getFilename().equals(KPaths.getKBase(false) + File.separator + "include" + File.separator + "io" + File.separator + "io.k")) {
            boolean symAllowed = false;
            for (String st : GlobalSettings.symbolicTags) {
                if (!node.containsAttribute(st)) continue;
                symAllowed = true;
            }
            if (!GlobalSettings.symbolicTags.isEmpty() && !symAllowed) {
                return super.transform(node);
            }
            List<Attribute> attrs = node.getAttributes().getContents();
            attrs.add(new Attribute(SymbolicBackend.SYMBOLIC, ""));
            Attributes atts = node.getAttributes().shallowCopy();
            atts.setContents(attrs);
            node = node.shallowCopy();
            node.setAttributes(atts);
            return node;
        }
        return super.transform(node);
    }

    static {
        if (GlobalSettings.javaBackend) {
            notSymbolicTags = Collections.emptySet();
        } else {
            notSymbolicTags = ImmutableSet.of("macro", "function", "structural", "anywhere", SymbolicBackend.NOTSYMBOLIC);
            if (!GlobalSettings.nonSymbolicTags.isEmpty()) {
                notSymbolicTags.addAll(GlobalSettings.nonSymbolicTags);
            }
        }
    }
}

