/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.backend.unparser;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Stack;
import org.kframework.compile.utils.MetaK;
import org.kframework.kil.ASTNode;
import org.kframework.kil.Bag;
import org.kframework.kil.Bracket;
import org.kframework.kil.Cell;
import org.kframework.kil.Collection;
import org.kframework.kil.CollectionItem;
import org.kframework.kil.Freezer;
import org.kframework.kil.FreezerHole;
import org.kframework.kil.Hole;
import org.kframework.kil.KApp;
import org.kframework.kil.KInjectedLabel;
import org.kframework.kil.KLabelConstant;
import org.kframework.kil.KSequence;
import org.kframework.kil.ListTerminator;
import org.kframework.kil.Map;
import org.kframework.kil.MapItem;
import org.kframework.kil.Production;
import org.kframework.kil.Rewrite;
import org.kframework.kil.Set;
import org.kframework.kil.Term;
import org.kframework.kil.TermCons;
import org.kframework.kil.Terminal;
import org.kframework.kil.Token;
import org.kframework.kil.UserList;
import org.kframework.kil.Variable;
import org.kframework.kil.loader.Context;
import org.kframework.kil.visitors.BasicVisitor;
import org.kframework.kil.visitors.CopyOnWriteTransformer;
import org.kframework.kil.visitors.exceptions.TransformerException;

public class AddBracketsFilter
extends CopyOnWriteTransformer {
    private Stack<Term> stack = new Stack();
    private Stack<Term> leftCapture = new Stack();
    private Stack<Term> rightCapture = new Stack();
    private Stack<Boolean> parens = new Stack();

    public AddBracketsFilter(Context context) {
        super("Add brackets", context);
    }

    @Override
    public ASTNode transform(TermCons ast) throws TransformerException {
        this.prepare(ast);
        ASTNode result = super.transform(ast);
        boolean needsParens = this.postpare();
        if (needsParens) {
            return new Bracket((Term)result, this.context);
        }
        return result;
    }

    @Override
    public ASTNode transform(Collection ast) throws TransformerException {
        this.prepare(ast);
        ASTNode result = super.transform(ast);
        boolean needsParens = this.postpare();
        if (needsParens) {
            return new Bracket((Term)result, this.context);
        }
        return result;
    }

    @Override
    public ASTNode transform(MapItem ast) throws TransformerException {
        this.prepare(ast);
        ASTNode result = super.transform(ast);
        boolean needsParens = this.postpare();
        if (needsParens) {
            return new Bracket((Term)result, this.context);
        }
        return result;
    }

    @Override
    public ASTNode transform(Cell ast) throws TransformerException {
        this.prepare(ast);
        ASTNode result = super.transform(ast);
        boolean needsParens = this.postpare();
        if (needsParens) {
            return new Bracket((Term)result, this.context);
        }
        return result;
    }

    @Override
    public ASTNode transform(CollectionItem ast) throws TransformerException {
        this.prepare(ast);
        ASTNode result = super.transform(ast);
        boolean needsParens = this.postpare();
        if (needsParens) {
            return new Bracket((Term)result, this.context);
        }
        return result;
    }

    @Override
    public ASTNode transform(KApp ast) throws TransformerException {
        this.prepare(ast);
        ASTNode result = super.transform(ast);
        boolean needsParens = this.postpare();
        if (needsParens) {
            return new Bracket((Term)result, this.context);
        }
        return result;
    }

    @Override
    public ASTNode transform(Hole ast) throws TransformerException {
        this.prepare(ast);
        ASTNode result = super.transform(ast);
        boolean needsParens = this.postpare();
        if (needsParens) {
            return new Bracket((Term)result, this.context);
        }
        return result;
    }

    @Override
    public ASTNode transform(Freezer ast) throws TransformerException {
        this.prepare(ast);
        ASTNode result = super.transform(ast);
        boolean needsParens = this.postpare();
        if (needsParens) {
            return new Bracket((Term)result, this.context);
        }
        return result;
    }

    @Override
    public ASTNode transform(KInjectedLabel ast) throws TransformerException {
        this.prepare(ast);
        ASTNode result = super.transform(ast);
        boolean needsParens = this.postpare();
        if (needsParens) {
            return new Bracket((Term)result, this.context);
        }
        return result;
    }

    private boolean isUnary(Term t) {
        if (t instanceof TermCons) {
            TermCons tc = (TermCons)t;
            Production p = tc.getProduction();
            if (p.isListDecl()) {
                UserList userList = (UserList)p.getItems().get(0);
                if (tc.getContents().get(1) instanceof ListTerminator && tc.getContents().get(1).getSort().equals(p.getSort()) && this.context.isSubsortedEq(userList.getSort(), tc.getContents().get(0).getSort())) {
                    return true;
                }
            }
            return tc.getProduction().getArity() == 1;
        }
        if (t instanceof MapItem) {
            return false;
        }
        if (t instanceof CollectionItem) {
            return true;
        }
        return t instanceof Cell || t instanceof Freezer || t instanceof KInjectedLabel;
    }

    private Associativity getAssociativity(Term t) {
        if (t instanceof TermCons) {
            TermCons tc = (TermCons)t;
            Production p = tc.getProduction();
            if (p.isListDecl()) {
                UserList userList = (UserList)p.getItems().get(0);
                if (tc.getContents().get(1) instanceof ListTerminator && tc.getContents().get(1).getSort().equals(p.getSort()) && this.context.isSubsortedEq(userList.getSort(), tc.getContents().get(0).getSort())) {
                    return Associativity.NONE;
                }
                return Associativity.RIGHT;
            }
            if (p.getAttributes().containsKey("left")) {
                return Associativity.LEFT;
            }
            if (p.getAttributes().containsKey("right")) {
                return Associativity.RIGHT;
            }
            if (p.getAttributes().containsKey("non-assoc")) {
                return Associativity.NONASSOC;
            }
        } else if (t instanceof Collection) {
            return Associativity.ASSOC;
        }
        return Associativity.NONE;
    }

    private boolean getAssociativity(Term inner, Term outer) {
        if (!(inner instanceof TermCons) || !(outer instanceof TermCons)) {
            return false;
        }
        TermCons tcInner = (TermCons)inner;
        TermCons tcOuter = (TermCons)outer;
        if (tcInner.getCons().equals(tcOuter.getCons())) {
            return true;
        }
        if (this.context.associativity.get(tcInner.getCons()) == null) {
            return false;
        }
        return this.context.associativity.get(tcInner.getCons()).contains(tcOuter.getProduction());
    }

    private boolean isAtom(Term inner) {
        TermCons tc;
        if (inner instanceof KLabelConstant) {
            return true;
        }
        if (inner instanceof KApp && ((KApp)inner).getLabel() instanceof Token) {
            return true;
        }
        if (inner instanceof ListTerminator) {
            return true;
        }
        if (inner instanceof FreezerHole) {
            return true;
        }
        if (inner instanceof Hole) {
            return true;
        }
        if (inner instanceof Variable) {
            return true;
        }
        return inner instanceof TermCons && (tc = (TermCons)inner).getProduction().getArity() == 0;
    }

    private EnumSet<Fixity> getFixity(Term t) {
        if (this.isAtom(t)) {
            return EnumSet.noneOf(Fixity.class);
        }
        if (t instanceof TermCons) {
            TermCons tc = (TermCons)t;
            Production p = tc.getProduction();
            EnumSet<Fixity> set = EnumSet.noneOf(Fixity.class);
            if (!(p.getItems().get(0) instanceof Terminal)) {
                set.add(Fixity.BARE_LEFT);
            }
            if (!(p.getItems().get(p.getItems().size() - 1) instanceof Terminal)) {
                set.add(Fixity.BARE_RIGHT);
            }
            return set;
        }
        if (t instanceof Collection || t instanceof MapItem || t instanceof Freezer) {
            return EnumSet.allOf(Fixity.class);
        }
        if (t instanceof CollectionItem || t instanceof Cell) {
            return EnumSet.noneOf(Fixity.class);
        }
        if (t instanceof KApp) {
            return EnumSet.of(Fixity.BARE_LEFT);
        }
        if (t instanceof KInjectedLabel) {
            return EnumSet.of(Fixity.BARE_RIGHT);
        }
        throw new UnsupportedOperationException("term fixity");
    }

    private EnumSet<Fixity> getPosition(Term inner, Term outer) {
        List<Term> childTerms;
        EnumSet<Fixity> set = EnumSet.noneOf(Fixity.class);
        if (outer instanceof TermCons) {
            TermCons tc = (TermCons)outer;
            childTerms = tc.getContents();
            Production p = tc.getProduction();
            if (p.isListDecl()) {
                UserList userList = (UserList)p.getItems().get(0);
                if (tc.getContents().get(1) instanceof ListTerminator && tc.getContents().get(1).getSort().equals(p.getSort()) && this.context.isSubsortedEq(userList.getSort(), tc.getContents().get(0).getSort())) {
                    return EnumSet.allOf(Fixity.class);
                }
            }
        } else if (outer instanceof Collection) {
            Collection c = (Collection)outer;
            childTerms = c.getContents();
        } else if (outer instanceof MapItem) {
            MapItem m = (MapItem)outer;
            childTerms = new ArrayList<Term>();
            childTerms.add(m.getKey());
            childTerms.add(m.getValue());
        } else {
            if (outer instanceof CollectionItem || outer instanceof Cell || outer instanceof KInjectedLabel || outer instanceof Freezer) {
                return EnumSet.allOf(Fixity.class);
            }
            if (outer instanceof KApp) {
                KApp kapp = (KApp)outer;
                childTerms = new ArrayList<Term>();
                childTerms.add(kapp.getLabel());
                childTerms.add(kapp.getChild());
            } else {
                throw new UnsupportedOperationException("position fixity");
            }
        }
        if (childTerms.get(0) == inner) {
            set.add(Fixity.BARE_LEFT);
        }
        if (childTerms.get(childTerms.size() - 1) == inner) {
            set.add(Fixity.BARE_RIGHT);
        }
        return set;
    }

    private static boolean contains(Term outer, Term inner, Context context) {
        ContainsVisitor visit = new ContainsVisitor(inner, context);
        outer.accept(visit);
        return visit.getFound();
    }

    private EnumSet<Fixity> getFixity(Term inner, Term outer) {
        if (outer instanceof TermCons) {
            int i;
            TermCons tc = (TermCons)outer;
            for (i = 0; i < tc.getContents().size() && !AddBracketsFilter.contains(tc.getContents().get(i), inner, this.context); ++i) {
            }
            Production p = tc.getProduction();
            EnumSet<Fixity> set = EnumSet.noneOf(Fixity.class);
            if (!p.hasTerminalToRight(i)) {
                set.add(Fixity.BARE_RIGHT);
            }
            if (!p.hasTerminalToLeft(i)) {
                set.add(Fixity.BARE_LEFT);
            }
            if (p.isListDecl()) {
                UserList userList = (UserList)p.getItems().get(0);
                if (tc.getContents().get(1) instanceof ListTerminator && tc.getContents().get(1).getSort().equals(p.getSort()) && this.context.isSubsortedEq(userList.getSort(), tc.getContents().get(0).getSort())) {
                    return EnumSet.allOf(Fixity.class);
                }
            }
            return set;
        }
        if (outer instanceof List || outer instanceof Set || outer instanceof Map || outer instanceof Bag) {
            return EnumSet.allOf(Fixity.class);
        }
        if (outer instanceof Collection) {
            int i;
            Collection c = (Collection)outer;
            for (i = 0; i < c.getContents().size() && !AddBracketsFilter.contains(c.getContents().get(i), inner, this.context); ++i) {
            }
            EnumSet<Fixity> set = EnumSet.allOf(Fixity.class);
            if (i != 0) {
                set.remove((Object)Fixity.BARE_LEFT);
            }
            if (i != c.getContents().size()) {
                set.remove((Object)Fixity.BARE_RIGHT);
            }
            return set;
        }
        if (outer instanceof MapItem) {
            MapItem m = (MapItem)outer;
            if (AddBracketsFilter.contains(m.getKey(), inner, this.context)) {
                return EnumSet.of(Fixity.BARE_LEFT);
            }
            return EnumSet.of(Fixity.BARE_RIGHT);
        }
        if (outer instanceof CollectionItem) {
            return EnumSet.noneOf(Fixity.class);
        }
        if (outer instanceof Cell) {
            return EnumSet.noneOf(Fixity.class);
        }
        if (outer instanceof KApp) {
            KApp kapp = (KApp)outer;
            if (AddBracketsFilter.contains(kapp.getLabel(), inner, this.context)) {
                return EnumSet.of(Fixity.BARE_LEFT);
            }
            return EnumSet.noneOf(Fixity.class);
        }
        if (outer instanceof Freezer) {
            return EnumSet.allOf(Fixity.class);
        }
        if (outer instanceof KInjectedLabel) {
            return EnumSet.of(Fixity.BARE_RIGHT);
        }
        throw new UnsupportedOperationException("subterm fixity");
    }

    private boolean isPriorityWrong(Term outer, Term inner) {
        KInjectedLabel lbl;
        String sort;
        if (outer instanceof TermCons) {
            TermCons tcOuter = (TermCons)outer;
            for (int i = 0; i < tcOuter.getContents().size(); ++i) {
                if (!this.context.isSubsortedEq(tcOuter.getProduction().getChildSort(i), inner.getSort())) continue;
                return inner instanceof TermCons && this.context.isPriorityWrong(tcOuter.getProduction().getKLabel(), ((TermCons)inner).getProduction().getKLabel());
            }
            return !inner.getSort().equals("K");
        }
        if (inner instanceof Rewrite && !(outer instanceof Cell)) {
            return true;
        }
        if (inner instanceof KSequence && outer instanceof TermCons) {
            return true;
        }
        if (outer instanceof KInjectedLabel && MetaK.isKSort(sort = (lbl = (KInjectedLabel)outer).getTerm().getSort())) {
            if (!this.context.isSubsortedEq(sort = KInjectedLabel.getInjectedSort(sort), inner.getSort())) {
                return true;
            }
        }
        return false;
    }

    private void prepare(Term ast) throws TransformerException {
        if (!this.stack.empty()) {
            Term lc = null;
            Term rc = null;
            Term outer = this.stack.peek();
            EnumSet<Fixity> fixity = this.getFixity(outer);
            if (!this.leftCapture.empty()) {
                lc = this.leftCapture.peek();
            }
            if (!this.rightCapture.empty()) {
                rc = this.rightCapture.peek();
            }
            boolean needsParens = this.parens.peek();
            EnumSet<Fixity> position = this.getPosition(ast, outer);
            if (this.isUnary(outer) && fixity.contains((Object)Fixity.BARE_LEFT) && fixity.contains((Object)Fixity.BARE_RIGHT)) {
                if (needsParens) {
                    lc = null;
                    rc = null;
                }
            } else if (position.contains((Object)Fixity.BARE_LEFT) && fixity.contains((Object)Fixity.BARE_LEFT)) {
                rc = outer;
                if (needsParens) {
                    lc = null;
                }
            } else if (position.contains((Object)Fixity.BARE_RIGHT) && fixity.contains((Object)Fixity.BARE_RIGHT)) {
                lc = outer;
                if (needsParens) {
                    rc = null;
                }
            } else {
                lc = null;
                rc = null;
            }
            this.leftCapture.push(lc);
            this.rightCapture.push(rc);
            this.parens.push(this.needsParentheses(ast, outer, lc, rc));
        } else {
            this.leftCapture.push(null);
            this.rightCapture.push(null);
            this.parens.push(false);
        }
        this.stack.push(ast);
    }

    private boolean postpare() {
        Term inner = this.stack.pop();
        this.leftCapture.pop();
        this.rightCapture.pop();
        boolean needsParens = this.parens.pop();
        return needsParens;
    }

    private boolean getImplicitPriority(Term inner, Term outer) {
        return false;
    }

    private boolean needsParentheses(Term inner, Term outer, Term leftCapture, Term rightCapture) throws TransformerException {
        try {
            boolean priority = this.isPriorityWrong(outer, inner);
            boolean inversePriority = this.isPriorityWrong(inner, outer);
            Associativity assoc = this.getAssociativity(outer);
            EnumSet<Fixity> fixity = this.getFixity(inner, outer);
            EnumSet<Fixity> innerFixity = this.getFixity(inner);
            if (this.isAtom(inner)) {
                return false;
            }
            if (fixity.size() == 0) {
                return false;
            }
            if (priority) {
                return true;
            }
            if (this.isUnary(inner) && innerFixity.contains((Object)Fixity.BARE_LEFT) && innerFixity.contains((Object)Fixity.BARE_RIGHT)) {
                return false;
            }
            if (innerFixity.contains((Object)Fixity.BARE_RIGHT) && rightCapture != null) {
                priority = this.isPriorityWrong(rightCapture, inner);
                inversePriority = this.isPriorityWrong(inner, rightCapture);
                if (assoc == Associativity.NONASSOC && !inversePriority) {
                    return true;
                }
                if (assoc == Associativity.NONE && !inversePriority) {
                    return true;
                }
                if (assoc == Associativity.RIGHT && !inversePriority) {
                    return true;
                }
                if (assoc == Associativity.LEFT && !inversePriority && !this.getAssociativity(inner, rightCapture)) {
                    return true;
                }
            }
            if (innerFixity.contains((Object)Fixity.BARE_LEFT) && leftCapture != null) {
                priority = this.isPriorityWrong(leftCapture, inner);
                inversePriority = this.isPriorityWrong(inner, leftCapture);
                if (assoc == Associativity.NONASSOC && !inversePriority) {
                    return true;
                }
                if (assoc == Associativity.NONE && !inversePriority) {
                    return true;
                }
                if (assoc == Associativity.LEFT && !inversePriority) {
                    return true;
                }
                if (assoc == Associativity.RIGHT && !inversePriority && !this.getAssociativity(inner, leftCapture)) {
                    return true;
                }
            }
            return false;
        }
        catch (UnsupportedOperationException e) {
            return true;
        }
    }

    private static class ContainsVisitor
    extends BasicVisitor {
        private boolean found = false;
        private Term inner;

        public ContainsVisitor(Term inner, Context context) {
            super("Term contains target term", context);
            this.inner = inner;
        }

        @Override
        public void visit(Term t) {
            if (t == this.inner) {
                this.found = true;
            }
            super.visit(t);
        }

        public boolean getFound() {
            return this.found;
        }
    }

    private static enum Fixity {
        BARE_LEFT,
        BARE_RIGHT;

    }

    private static enum Associativity {
        LEFT,
        RIGHT,
        NONASSOC,
        ASSOC,
        NONE;


        public boolean equals2(Associativity o) {
            return this == o || this == NONE || o == NONE;
        }
    }
}

