/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.backend.unparser;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import org.kframework.backend.unparser.UnparserFilter;
import org.kframework.kil.ASTNode;
import org.kframework.kil.Ambiguity;
import org.kframework.kil.Bracket;
import org.kframework.kil.Cast;
import org.kframework.kil.Cell;
import org.kframework.kil.Collection;
import org.kframework.kil.CollectionItem;
import org.kframework.kil.Freezer;
import org.kframework.kil.Hole;
import org.kframework.kil.KApp;
import org.kframework.kil.KInjectedLabel;
import org.kframework.kil.MapItem;
import org.kframework.kil.Sentence;
import org.kframework.kil.Term;
import org.kframework.kil.TermCons;
import org.kframework.kil.Token;
import org.kframework.kil.Variable;
import org.kframework.kil.loader.Context;
import org.kframework.kil.visitors.BasicTransformer;
import org.kframework.kil.visitors.BasicVisitor;
import org.kframework.kil.visitors.exceptions.TransformerException;
import org.kframework.krun.ColorSetting;
import org.kframework.parser.DefinitionLoader;
import org.kframework.parser.concrete.KParser;

public class AddBracketsFilter2
extends BasicTransformer {
    private Term reparsed = null;
    public Map<String, Term> substitution = new HashMap<String, Term>();
    private boolean atTop = true;

    public AddBracketsFilter2(Context context) throws IOException {
        super("Add more brackets", context);
        KParser.ImportTbl(context.kompiled.getCanonicalPath() + "/def/Concrete.tbl");
    }

    public AddBracketsFilter2(Term reparsed, Context context) {
        super("Add brackets to term based on parse forest", context);
        this.reparsed = reparsed;
    }

    @Override
    public ASTNode transform(TermCons ast) throws TransformerException {
        boolean tmp = this.atTop;
        this.atTop = false;
        ASTNode result = super.transform(ast);
        return this.postpare((Term)result, tmp);
    }

    @Override
    public ASTNode transform(Collection ast) throws TransformerException {
        boolean tmp = this.atTop;
        this.atTop = false;
        ASTNode result = super.transform(ast);
        return this.postpare((Term)result, tmp);
    }

    @Override
    public ASTNode transform(MapItem ast) throws TransformerException {
        boolean tmp = this.atTop;
        this.atTop = false;
        ASTNode result = super.transform(ast);
        return this.postpare((Term)result, tmp);
    }

    @Override
    public ASTNode transform(Cell ast) throws TransformerException {
        boolean tmp = this.atTop;
        this.atTop = false;
        ASTNode result = super.transform(ast);
        return this.postpare((Term)result, tmp);
    }

    @Override
    public ASTNode transform(CollectionItem ast) throws TransformerException {
        boolean tmp = this.atTop;
        this.atTop = false;
        ASTNode result = super.transform(ast);
        return this.postpare((Term)result, tmp);
    }

    @Override
    public ASTNode transform(KApp ast) throws TransformerException {
        if (ast.getLabel() instanceof Token) {
            return ast;
        }
        boolean tmp = this.atTop;
        this.atTop = false;
        ASTNode result = super.transform(ast);
        return this.postpare((Term)result, tmp);
    }

    @Override
    public ASTNode transform(Hole ast) throws TransformerException {
        boolean tmp = this.atTop;
        this.atTop = false;
        ASTNode result = super.transform(ast);
        return this.postpare((Term)result, tmp);
    }

    @Override
    public ASTNode transform(Freezer ast) throws TransformerException {
        boolean tmp = this.atTop;
        this.atTop = false;
        ASTNode result = super.transform(ast);
        return this.postpare((Term)result, tmp);
    }

    @Override
    public ASTNode transform(KInjectedLabel ast) throws TransformerException {
        boolean tmp = this.atTop;
        this.atTop = false;
        ASTNode result = super.transform(ast);
        return this.postpare((Term)result, tmp);
    }

    private ASTNode postpare(Term ast, boolean atTop) throws TransformerException {
        if (this.reparsed != null) {
            ASTNode result = this.addBracketsIfNeeded(ast);
            if (atTop && result instanceof Bracket) {
                return new Cast(result.getLocation(), result.getFilename(), (Term)result, this.context);
            }
            return result;
        }
        UnparserFilter unparser = new UnparserFilter(false, ColorSetting.OFF, false, true, this.context);
        ast.accept(unparser);
        String unparsed = unparser.getResult();
        try {
            ASTNode rule = DefinitionLoader.parsePatternAmbiguous(unparsed, this.context);
            Term reparsed = ((Sentence)rule).getBody();
            reparsed.accept(new AdjustLocations(this.context));
            if (!reparsed.contains(ast)) {
                return this.replaceWithVar(ast);
            }
            return ast.accept(new AddBracketsFilter2(reparsed, this.context));
        }
        catch (TransformerException e) {
            return this.replaceWithVar(ast);
        }
    }

    private Variable replaceWithVar(Term ast) {
        Variable var = Variable.getFreshVar(ast.getSort());
        this.substitution.put(var.getName(), ast);
        return var;
    }

    private ASTNode addBracketsIfNeeded(Term ast) throws TransformerException {
        TraverseForest trans = new TraverseForest(ast, this.context);
        this.reparsed = (Term)this.reparsed.accept(trans);
        if (trans.needsParens) {
            return new Bracket(ast.getLocation(), ast.getFilename(), ast, this.context);
        }
        return ast;
    }

    private class TraverseForest
    extends BasicTransformer {
        private Term ast;
        public boolean needsParens;
        private boolean hasTerm;
        private boolean needsCast;
        private String realLocation;

        public TraverseForest(Term ast, Context context) {
            super("Determine if term needs parentheses", context);
            this.ast = ast;
        }

        @Override
        public ASTNode transform(Ambiguity amb) throws TransformerException {
            this.realLocation = this.ast.getLocation();
            for (int i = amb.getContents().size() - 1; i >= 0; --i) {
                Term t = amb.getContents().get(i);
                boolean tmp = this.hasTerm;
                this.hasTerm = false;
                t.accept(this);
                if (!this.hasTerm) {
                    this.needsParens = true;
                    amb.getContents().remove(i);
                }
                this.hasTerm = tmp;
            }
            if (amb.getContents().size() == 1) {
                return amb.getContents().get(0);
            }
            return amb;
        }

        @Override
        public ASTNode transform(Term t) throws TransformerException {
            if (t.equals(this.ast) && t.getLocation().equals(this.realLocation)) {
                this.hasTerm = true;
            }
            return t;
        }
    }

    private class GetRealLocation
    extends BasicVisitor {
        private Term ast;
        public Term realTerm;

        public GetRealLocation(Term ast, Context context) {
            super("Find term in parse forest", context);
            this.ast = ast;
        }

        @Override
        public void visit(Term t) {
            if (t.contains(this.ast)) {
                this.realTerm = t;
            }
        }
    }

    private class AdjustLocations
    extends BasicVisitor {
        public AdjustLocations(Context context) {
            super("Apply first-line location offset", context);
        }

        @Override
        public void visit(ASTNode ast) {
            if (ast.getLocation().equals("generated")) {
                return;
            }
            Scanner scanner = new Scanner(ast.getLocation()).useDelimiter("[,)]").skip("\\(");
            int beginLine = scanner.nextInt();
            int beginCol = scanner.nextInt();
            int endLine = scanner.nextInt();
            int endCol = scanner.nextInt();
            ast.setLocation("(" + beginLine + "," + beginCol + "," + endLine + "," + endCol + ")");
        }
    }
}

