/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.backend.unparser;

import java.util.Stack;
import org.kframework.backend.unparser.IndentationOptions;

public class Indenter {
    String endl = System.getProperty("line.separator");
    protected Stack<Integer> indents = new Stack();
    protected StringBuilder stringBuilder = new StringBuilder();
    protected boolean atBOL = true;
    protected IndentationOptions indentationOptions;
    private int lineNo = 1;
    private int colNo = 1;

    public Indenter() {
        this(new IndentationOptions());
    }

    public Indenter(IndentationOptions indentationOptions) {
        this.indentationOptions = indentationOptions;
    }

    private int indentSize() {
        int size = 0;
        for (Integer i : this.indents) {
            size += i.intValue();
        }
        return size;
    }

    public void setWidth(int newWidth) {
        this.indentationOptions.setWidth(newWidth);
    }

    public int getWidth() {
        return this.indentationOptions.getWidth();
    }

    public int getAuxTabSize() {
        return this.indentationOptions.getAuxTabSize();
    }

    public void write(String string) {
        if (this.atBOL) {
            for (int i = 0; i < this.indentSize(); ++i) {
                this.stringBuilder.append(" ");
                ++this.colNo;
            }
        }
        int indexEndLine = this.stringBuilder.lastIndexOf(this.endl) + this.endl.length();
        int indexEndString = this.stringBuilder.length();
        if (indexEndString - indexEndLine + string.length() > this.getWidth()) {
            this.stringBuilder.append(this.endl);
            ++this.lineNo;
            this.colNo = 1;
            for (int i = 0; i < this.indentSize() + this.getAuxTabSize(); ++i) {
                this.stringBuilder.append(" ");
                ++this.colNo;
            }
        }
        this.stringBuilder.append(string);
        this.colNo += string.length();
        this.atBOL = false;
    }

    public void endLine() {
        this.atBOL = true;
        this.stringBuilder.append(this.endl);
        ++this.lineNo;
        this.colNo = 1;
    }

    public void indentToCurrent() {
        int indexEndLine = this.stringBuilder.lastIndexOf(this.endl);
        int indexEndString = this.stringBuilder.length();
        this.indents.push(indexEndString - indexEndLine - this.indentSize());
    }

    public void indent(int size) {
        this.indents.push(this.indentationOptions.getTabSize() * size);
    }

    public void unindent() {
        this.indents.pop();
    }

    public StringBuilder getResult() {
        return this.stringBuilder;
    }

    public String toString() {
        return this.stringBuilder.toString();
    }

    public int getLineNo() {
        return this.lineNo;
    }

    public int getColNo() {
        return this.colNo;
    }
}

