/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.backend.unparser;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FilenameUtils;
import org.kframework.backend.Backend;
import org.kframework.backend.BasicBackend;
import org.kframework.backend.unparser.UnparserFilter;
import org.kframework.compile.utils.CompilerSteps;
import org.kframework.kil.Definition;
import org.kframework.kil.loader.Context;
import org.kframework.kil.visitors.exceptions.TransformerException;
import org.kframework.krun.ConcretizeSyntax;
import org.kframework.utils.Stopwatch;
import org.kframework.utils.file.FileUtil;
import org.kframework.utils.general.GlobalSettings;

public class UnflattenBackend
extends BasicBackend {
    private Backend backend;

    public UnflattenBackend(Stopwatch sw, Context context, Backend backend) {
        super(sw, context);
        this.backend = backend;
    }

    @Override
    public Definition lastStep(Definition def) {
        return this.backend.lastStep(def);
    }

    @Override
    public Definition firstStep(Definition def) {
        return this.backend.firstStep(def);
    }

    @Override
    public void run(Definition definition) throws IOException {
        ConcretizeSyntax concretizeSyntax = new ConcretizeSyntax(this.context);
        try {
            definition = (Definition)definition.accept(concretizeSyntax);
        }
        catch (TransformerException e) {
            System.err.println("Error unflattening syntax:");
            e.printStackTrace();
        }
        UnparserFilter unparserFilter = new UnparserFilter(this.context);
        definition.accept(unparserFilter);
        String unparsedText = unparserFilter.getResult();
        FileUtil.save(this.context.dotk.getAbsolutePath() + "/def.k", unparsedText);
        FileUtil.save(GlobalSettings.outputDir + File.separator + FilenameUtils.removeExtension(GlobalSettings.mainFile.getName()) + ".unparsed.k", unparsedText);
    }

    @Override
    public String getDefaultStep() {
        return this.backend.getDefaultStep();
    }

    @Override
    public boolean autoinclude() {
        return this.backend.autoinclude();
    }

    @Override
    public CompilerSteps<Definition> getCompilationSteps() {
        return this.backend.getCompilationSteps();
    }
}

