/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.backend.unparser;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FilenameUtils;
import org.kframework.backend.BasicBackend;
import org.kframework.backend.unparser.UnparserFilter;
import org.kframework.kil.Definition;
import org.kframework.kil.loader.Context;
import org.kframework.kil.visitors.exceptions.TransformerException;
import org.kframework.krun.ConcretizeSyntax;
import org.kframework.utils.Stopwatch;
import org.kframework.utils.file.FileUtil;
import org.kframework.utils.general.GlobalSettings;

public class UnparserBackend
extends BasicBackend {
    private boolean unflattenFirst;

    public UnparserBackend(Stopwatch sw, Context context) {
        super(sw, context);
        this.unflattenFirst = false;
    }

    public UnparserBackend(Stopwatch sw, Context context, boolean unflattenFirst) {
        super(sw, context);
        this.unflattenFirst = unflattenFirst;
    }

    @Override
    public void run(Definition definition) throws IOException {
        if (this.unflattenFirst) {
            ConcretizeSyntax concretizeSyntax = new ConcretizeSyntax(this.context);
            try {
                definition = (Definition)definition.accept(concretizeSyntax);
            }
            catch (TransformerException e) {
                System.err.println("Error unflattening syntax:");
                e.printStackTrace();
            }
        }
        UnparserFilter unparserFilter = new UnparserFilter(this.context);
        definition.accept(unparserFilter);
        String unparsedText = unparserFilter.getResult();
        FileUtil.save(this.context.dotk.getAbsolutePath() + "/def.k", unparsedText);
        FileUtil.save(GlobalSettings.outputDir + File.separator + FilenameUtils.removeExtension(GlobalSettings.mainFile.getName()) + ".unparsed.k", unparsedText);
    }

    @Override
    public String getDefaultStep() {
        return "FirstStep";
    }
}

