/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.backend.unparser;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.kframework.backend.unparser.Indenter;
import org.kframework.compile.utils.MetaK;
import org.kframework.kil.ASTNode;
import org.kframework.kil.Ambiguity;
import org.kframework.kil.Attribute;
import org.kframework.kil.Attributes;
import org.kframework.kil.BackendTerm;
import org.kframework.kil.Bag;
import org.kframework.kil.BagItem;
import org.kframework.kil.Bracket;
import org.kframework.kil.Cast;
import org.kframework.kil.Cell;
import org.kframework.kil.Collection;
import org.kframework.kil.CollectionItem;
import org.kframework.kil.Configuration;
import org.kframework.kil.Definition;
import org.kframework.kil.Freezer;
import org.kframework.kil.FreezerHole;
import org.kframework.kil.Hole;
import org.kframework.kil.Import;
import org.kframework.kil.KApp;
import org.kframework.kil.KInjectedLabel;
import org.kframework.kil.KLabel;
import org.kframework.kil.KLabelConstant;
import org.kframework.kil.KList;
import org.kframework.kil.KSequence;
import org.kframework.kil.ListItem;
import org.kframework.kil.ListTerminator;
import org.kframework.kil.LiterateDefinitionComment;
import org.kframework.kil.Map;
import org.kframework.kil.MapItem;
import org.kframework.kil.Module;
import org.kframework.kil.PriorityBlock;
import org.kframework.kil.Production;
import org.kframework.kil.ProductionItem;
import org.kframework.kil.Require;
import org.kframework.kil.Rewrite;
import org.kframework.kil.Rule;
import org.kframework.kil.Set;
import org.kframework.kil.SetItem;
import org.kframework.kil.Sort;
import org.kframework.kil.Syntax;
import org.kframework.kil.Term;
import org.kframework.kil.TermComment;
import org.kframework.kil.TermCons;
import org.kframework.kil.Terminal;
import org.kframework.kil.Token;
import org.kframework.kil.UserList;
import org.kframework.kil.Variable;
import org.kframework.kil.loader.Context;
import org.kframework.kil.visitors.BasicVisitor;
import org.kframework.krun.ColorSetting;
import org.kframework.krun.K;
import org.kframework.utils.ColorUtil;

public class UnparserFilterNew
extends BasicVisitor {
    protected Indenter indenter = new Indenter();
    private boolean firstPriorityBlock = false;
    private boolean firstProduction = false;
    private boolean inConfiguration = false;
    private boolean addParentheses;
    private int inTerm = 0;
    private ColorSetting color = ColorSetting.OFF;
    private boolean annotateLocation;
    public static int TAB = 4;
    private boolean forEquivalence = false;
    private List<String> variableList = new LinkedList<String>();
    private java.util.Map<Production, Integer> priorities = null;
    private Stack<ASTNode> stack = new Stack();
    private Definition definition;

    public void setForEquivalence() {
        this.forEquivalence = true;
    }

    public void setIndenter(Indenter indenter) {
        this.indenter = indenter;
    }

    public UnparserFilterNew(Context context, Definition definition) {
        this(false, context, definition);
    }

    public UnparserFilterNew(boolean inConfiguration, Context context, Definition definition) {
        this(inConfiguration, false, context, definition);
    }

    public UnparserFilterNew(boolean inConfiguration, boolean color, Context context, Definition definition) {
        this(inConfiguration, color ? ColorSetting.ON : ColorSetting.OFF, true, context, definition);
    }

    public UnparserFilterNew(boolean inConfiguration, ColorSetting color, boolean addParentheses, Context context, Definition definition) {
        this(inConfiguration, color, addParentheses, false, context, definition);
    }

    public UnparserFilterNew(boolean inConfiguration, ColorSetting color, boolean addParentheses, boolean annotateLocation, Context context, Definition definition) {
        super(context);
        this.inConfiguration = inConfiguration;
        this.color = color;
        this.inTerm = 0;
        this.addParentheses = addParentheses;
        this.annotateLocation = annotateLocation;
        this.definition = definition;
    }

    public String getResult() {
        return this.indenter.toString();
    }

    @Override
    public void visit(Definition def) {
        this.prepare(def);
        super.visit(def);
        this.postpare();
    }

    @Override
    public void visit(Import imp) {
        this.prepare(imp);
        if (!this.forEquivalence) {
            this.indenter.write("imports " + imp.getName());
            this.indenter.endLine();
        }
        this.postpare();
    }

    @Override
    public void visit(Module mod) {
        this.prepare(mod);
        if (!mod.isPredefined()) {
            if (!this.forEquivalence) {
                this.indenter.write("module " + mod.getName());
                this.indenter.endLine();
                this.indenter.endLine();
                this.indenter.indent(TAB);
            }
            super.visit(mod);
            if (!this.forEquivalence) {
                this.indenter.unindent();
                this.indenter.write("endmodule");
                this.indenter.endLine();
                this.indenter.endLine();
            }
        }
        this.postpare();
    }

    @Override
    public void visit(Syntax syn) {
        this.prepare(syn);
        this.firstPriorityBlock = true;
        this.indenter.write("syntax " + syn.getSort().getName());
        this.indenter.indentToCurrent();
        if (syn.getPriorityBlocks() != null) {
            for (PriorityBlock pb : syn.getPriorityBlocks()) {
                pb.accept(this);
            }
        }
        this.indenter.unindent();
        this.indenter.endLine();
        this.postpare();
    }

    @Override
    public void visit(PriorityBlock priorityBlock) {
        this.prepare(priorityBlock);
        if (this.firstPriorityBlock) {
            this.indenter.write(" ::=");
        } else {
            this.indenter.write("  >");
        }
        this.firstPriorityBlock = false;
        this.firstProduction = true;
        super.visit(priorityBlock);
        this.postpare();
    }

    @Override
    public void visit(Production prod) {
        this.prepare(prod);
        if (this.firstProduction) {
            this.indenter.write(" ");
        } else {
            this.indenter.write("  | ");
        }
        this.firstProduction = false;
        for (int i = 0; i < prod.getItems().size(); ++i) {
            ProductionItem pi = prod.getItems().get(i);
            pi.accept(this);
            if (i == prod.getItems().size() - 1) continue;
            this.indenter.write(" ");
        }
        prod.getAttributes().accept(this);
        this.indenter.endLine();
        this.postpare();
    }

    @Override
    public void visit(Sort sort) {
        this.prepare(sort);
        this.indenter.write(sort.getName());
        super.visit(sort);
        this.postpare();
    }

    @Override
    public void visit(Terminal terminal) {
        this.prepare(terminal);
        this.indenter.write("\"" + terminal.getTerminal() + "\"");
        super.visit(terminal);
        this.postpare();
    }

    @Override
    public void visit(UserList userList) {
        this.prepare(userList);
        this.indenter.write("List{" + userList.getSort() + ",\"" + userList.getSeparator() + "\"}");
        super.visit(userList);
        this.postpare();
    }

    @Override
    public void visit(KList listOfK) {
        this.prepare(listOfK);
        List<Term> termList = listOfK.getContents();
        for (int i = 0; i < termList.size(); ++i) {
            termList.get(i).accept(this);
            if (i == termList.size() - 1) continue;
            this.indenter.write(",, ");
        }
        if (termList.size() == 0) {
            this.indenter.write(".KList");
        }
        this.postpare();
    }

    @Override
    public void visit(Attributes attributes) {
        int i;
        this.prepare(attributes);
        LinkedList<String> reject = new LinkedList<String>();
        reject.add("cons");
        reject.add("kgeneratedlabel");
        reject.add("prefixlabel");
        reject.add("filename");
        reject.add("location");
        LinkedList<Attribute> attributeList = new LinkedList<Attribute>();
        List<Attribute> oldAttributeList = attributes.getContents();
        for (i = 0; i < oldAttributeList.size(); ++i) {
            if (reject.contains(oldAttributeList.get(i).getKey())) continue;
            attributeList.add(oldAttributeList.get(i));
        }
        if (!attributeList.isEmpty()) {
            this.indenter.write(" ");
            this.indenter.write("[");
            for (i = 0; i < attributeList.size(); ++i) {
                ((Attribute)attributeList.get(i)).accept(this);
                if (i == attributeList.size() - 1) continue;
                this.indenter.write(", ");
            }
            this.indenter.write("]");
        }
        this.postpare();
    }

    @Override
    public void visit(Attribute attribute) {
        this.prepare(attribute);
        this.indenter.write(attribute.getKey());
        if (!attribute.getValue().equals("")) {
            this.indenter.write("(" + attribute.getValue() + ")");
        }
        this.postpare();
    }

    @Override
    public void visit(Configuration configuration) {
        this.prepare(configuration);
        if (!this.forEquivalence) {
            this.indenter.write("configuration");
            this.indenter.endLine();
            this.indenter.indent(TAB);
            this.inConfiguration = true;
            configuration.getBody().accept(this);
            this.inConfiguration = false;
            this.indenter.unindent();
            this.indenter.endLine();
            this.indenter.endLine();
        }
        this.postpare();
    }

    @Override
    public void visit(Cell cell) {
        String declaredColor;
        this.prepare(cell);
        String attributes = "";
        for (Map.Entry<String, String> entry : cell.getCellAttributes().entrySet()) {
            if (entry.getKey() == "ellipses") continue;
            attributes = attributes + " " + entry.getKey() + "=\"" + entry.getValue() + "\"";
        }
        String colorCode = "";
        Cell declaredCell = this.context.cells.get(cell.getLabel());
        if (declaredCell != null && (declaredColor = declaredCell.getCellAttributes().get("color")) != null) {
            colorCode = ColorUtil.RgbToAnsi(ColorUtil.colors.get(declaredColor), this.color);
            this.indenter.write(colorCode);
        }
        this.indenter.write("<" + cell.getLabel() + attributes + ">");
        if (this.inConfiguration && this.inTerm == 0) {
            this.indenter.endLine();
            this.indenter.indent(TAB);
        } else if (cell.hasLeftEllipsis()) {
            this.indenter.write("... ");
        } else {
            this.indenter.write(" ");
        }
        if (!colorCode.equals("")) {
            this.indenter.write("\u001b[0m");
        }
        cell.getContents().accept(this);
        this.indenter.write(colorCode);
        if (this.inConfiguration && this.inTerm == 0) {
            this.indenter.endLine();
            this.indenter.unindent();
        } else if (cell.hasRightEllipsis()) {
            this.indenter.write(" ...");
        } else {
            this.indenter.write(" ");
        }
        this.indenter.write("</" + cell.getLabel() + ">");
        if (!colorCode.equals("")) {
            this.indenter.write("\u001b[0m");
        }
        this.postpare();
    }

    @Override
    public void visit(Variable variable) {
        this.prepare(variable);
        if (variable.isFresh()) {
            this.indenter.write("?");
        }
        this.indenter.write(variable.getName());
        if (!this.variableList.contains(variable.getName())) {
            this.indenter.write(":" + variable.getSort());
            this.variableList.add(variable.getName());
        }
        this.postpare();
    }

    @Override
    public void visit(ListTerminator terminator) {
        this.prepare(terminator);
        this.indenter.write(terminator.toString());
        this.postpare();
    }

    @Override
    public void visit(Rule rule) {
        this.prepare(rule);
        this.indenter.write("rule ");
        if (!"".equals(rule.getLabel())) {
            this.indenter.write("[" + rule.getLabel() + "]: ");
        }
        this.variableList.clear();
        rule.getBody().accept(this);
        if (rule.getRequires() != null) {
            this.indenter.write(" when ");
            rule.getRequires().accept(this);
        }
        if (rule.getEnsures() != null) {
            this.indenter.write(" ensures ");
            rule.getEnsures().accept(this);
        }
        rule.getAttributes().accept(this);
        this.indenter.endLine();
        this.indenter.endLine();
        this.postpare();
    }

    @Override
    public void visit(KApp kapp) {
        this.prepare(kapp);
        Term child = kapp.getChild();
        Term label = kapp.getLabel();
        if (label instanceof Token) {
            assert (child instanceof KList) : "child of KApp with Token is not KList";
            assert (((KList)child).isEmpty()) : "child of KApp with Token is not empty";
            ArrayList<Terminal> temp = this.findRightSyntax(label.getSort());
            if (!temp.isEmpty()) {
                this.indenter.write(temp.get(0).getTerminal());
            }
            this.indenter.write(((Token)label).value());
            if (temp.size() > 1) {
                this.indenter.write(temp.get(1).getTerminal());
            }
        } else if (K.output_mode.equals("pretty") && label instanceof KLabelConstant && ((KLabelConstant)label).getLabel().contains("'_")) {
            String rawLabel = null;
            ArrayList<Terminal> temp = this.findRightSyntax(label.getSort());
            rawLabel = !temp.isEmpty() ? (temp.size() > 1 ? temp.get(0).getTerminal() + ((KLabelConstant)label).getLabel().replaceAll("`", "``").replaceAll("\\(", "`(").replaceAll("\\)", "`)").replaceAll("'", "") + temp.get(1).getTerminal() : temp.get(0).getTerminal() + ((KLabelConstant)label).getLabel().replaceAll("`", "``").replaceAll("\\(", "`(").replaceAll("\\)", "`)").replaceAll("'", "") + " ") : " " + ((KLabelConstant)label).getLabel().replaceAll("`", "``").replaceAll("\\(", "`(").replaceAll("\\)", "`)").replaceAll("'", "") + " ";
            if (child instanceof KList) {
                List<Term> termList = ((KList)child).getContents();
                if (termList.size() == 0) {
                    this.indenter.write(rawLabel);
                } else {
                    int i = 0;
                    String[] rawLabelList = rawLabel.split("_");
                    for (i = 0; i < termList.size(); ++i) {
                        this.indenter.write(rawLabelList[i]);
                        if (i > 0) {
                            this.indenter.write(" ");
                        }
                        termList.get(i).accept(this);
                    }
                    this.indenter.write(rawLabelList[i]);
                }
            } else {
                this.indenter.write("(");
                child.accept(this);
                this.indenter.write(")");
            }
        } else {
            label.accept(this);
            this.indenter.write("(");
            child.accept(this);
            this.indenter.write(")");
        }
        this.postpare();
    }

    @Override
    public void visit(KSequence ksequence) {
        this.prepare(ksequence);
        List<Term> contents = ksequence.getContents();
        if (!contents.isEmpty()) {
            for (int i = 0; i < contents.size(); ++i) {
                contents.get(i).accept(this);
                if (i == contents.size() - 1) continue;
                this.indenter.write(" ~> ");
            }
        } else {
            this.indenter.write(".K");
        }
        this.postpare();
    }

    @Override
    public void visit(TermCons termCons) {
        ArrayList<Terminal> temp = this.findRightSyntax(termCons.getSort());
        if (!temp.isEmpty()) {
            this.indenter.write(temp.get(0).getTerminal());
        }
        ++this.inTerm;
        Production production = termCons.getProduction();
        if (production.isListDecl()) {
            UserList userList = (UserList)production.getItems().get(0);
            String separator = userList.getSeparator();
            List<Term> contents = termCons.getContents();
            contents.get(0).accept(this);
            if (!(contents.get(1) instanceof ListTerminator) || !K.output_mode.equals("pretty") && !K.output_mode.equals("kore")) {
                this.indenter.write(separator + " ");
                contents.get(1).accept(this);
            }
        } else {
            int where = 0;
            for (int i = 0; i < production.getItems().size(); ++i) {
                ProductionItem productionItem = production.getItems().get(i);
                if (!(productionItem instanceof Terminal)) {
                    if (!(termCons.getContents().get(where) instanceof ListTerminator) || !K.output_mode.equals("pretty") && !K.output_mode.equals("kore")) {
                        termCons.getContents().get(where++).accept(this);
                    } else {
                        ++where;
                    }
                } else {
                    this.indenter.write(((Terminal)productionItem).getTerminal());
                }
                if (i == production.getItems().size() - 1) continue;
                this.indenter.write(" ");
            }
        }
        --this.inTerm;
        if (temp.size() > 1) {
            this.indenter.write(temp.get(1).getTerminal());
        }
    }

    @Override
    public void visit(Rewrite rewrite) {
        this.prepare(rewrite);
        rewrite.getLeft().accept(this);
        this.indenter.write(" => ");
        rewrite.getRight().accept(this);
        this.postpare();
    }

    @Override
    public void visit(KLabelConstant kLabelConstant) {
        this.prepare(kLabelConstant);
        this.indenter.write(kLabelConstant.getLabel().replaceAll("`", "``").replaceAll("\\(", "`(").replaceAll("\\)", "`)"));
        this.postpare();
    }

    @Override
    public void visit(Collection collection) {
        this.prepare(collection);
        List<Term> contents = collection.getContents();
        for (int i = 0; i < contents.size(); ++i) {
            contents.get(i).accept(this);
            if (i == contents.size() - 1) continue;
            if (this.inConfiguration && this.inTerm == 0) {
                this.indenter.endLine();
                continue;
            }
            this.indenter.write(" ");
        }
        if (contents.size() == 0) {
            this.indenter.write("." + collection.getSort());
        }
        this.postpare();
    }

    @Override
    public void visit(CollectionItem collectionItem) {
        this.prepare(collectionItem);
        super.visit(collectionItem);
        this.postpare();
    }

    @Override
    public void visit(BagItem bagItem) {
        this.prepare(bagItem);
        this.indenter.write("BagItem(");
        super.visit(bagItem);
        this.indenter.write(")");
        this.postpare();
    }

    @Override
    public void visit(ListItem listItem) {
        this.prepare(listItem);
        this.indenter.write("ListItem(");
        super.visit(listItem);
        this.indenter.write(")");
        this.postpare();
    }

    @Override
    public void visit(SetItem setItem) {
        this.prepare(setItem);
        this.indenter.write("SetItem(");
        super.visit(setItem);
        this.indenter.write(")");
        this.postpare();
    }

    @Override
    public void visit(MapItem mapItem) {
        this.prepare(mapItem);
        mapItem.getKey().accept(this);
        this.indenter.write(" |-> ");
        mapItem.getValue().accept(this);
        this.postpare();
    }

    @Override
    public void visit(Hole hole) {
        this.prepare(hole);
        this.indenter.write("HOLE");
        this.postpare();
    }

    @Override
    public void visit(FreezerHole hole) {
        this.prepare(hole);
        this.indenter.write("HOLE(" + hole.getIndex() + ")");
        this.postpare();
    }

    @Override
    public void visit(Freezer freezer) {
        this.prepare(freezer);
        freezer.getTerm().accept(this);
        this.postpare();
    }

    @Override
    public void visit(KInjectedLabel kInjectedLabel) {
        this.prepare(kInjectedLabel);
        Term term = kInjectedLabel.getTerm();
        if (MetaK.isKSort(term.getSort())) {
            this.indenter.write(KInjectedLabel.getInjectedSort(term.getSort()));
            this.indenter.write("2KLabel ");
        } else {
            this.indenter.write("# ");
        }
        term.accept(this);
        this.postpare();
    }

    @Override
    public void visit(KLabel kLabel) {
        this.prepare(kLabel);
        this.indenter.endLine();
        this.indenter.write("Don't know how to pretty print KLabel");
        this.indenter.endLine();
        super.visit(kLabel);
        this.postpare();
    }

    @Override
    public void visit(TermComment termComment) {
        this.prepare(termComment);
        this.indenter.write("<br/>");
        super.visit(termComment);
        this.postpare();
    }

    @Override
    public void visit(org.kframework.kil.List list) {
        this.prepare(list);
        super.visit(list);
        this.postpare();
    }

    @Override
    public void visit(Map map) {
        this.prepare(map);
        super.visit(map);
        this.postpare();
    }

    @Override
    public void visit(Bag bag) {
        this.prepare(bag);
        super.visit(bag);
        this.postpare();
    }

    @Override
    public void visit(Set set) {
        this.prepare(set);
        super.visit(set);
        this.postpare();
    }

    @Override
    public void visit(Ambiguity ambiguity) {
        this.prepare(ambiguity);
        this.indenter.write("amb(");
        this.indenter.endLine();
        this.indenter.indent(TAB);
        List<Term> contents = ambiguity.getContents();
        for (int i = 0; i < contents.size(); ++i) {
            contents.get(i).accept(this);
            if (i == contents.size() - 1) continue;
            this.indenter.write(",");
            this.indenter.endLine();
        }
        this.indenter.endLine();
        this.indenter.unindent();
        this.indenter.write(")");
        this.postpare();
    }

    @Override
    public void visit(org.kframework.kil.Context context) {
        this.prepare(context);
        this.indenter.write("context ");
        this.variableList.clear();
        context.getBody().accept(this);
        if (context.getRequires() != null) {
            this.indenter.write(" when ");
            context.getRequires().accept(this);
        }
        if (context.getEnsures() != null) {
            this.indenter.write(" ensures ");
            context.getEnsures().accept(this);
        }
        context.getAttributes().accept(this);
        this.indenter.endLine();
        this.indenter.endLine();
        this.postpare();
    }

    @Override
    public void visit(LiterateDefinitionComment literateDefinitionComment) {
        this.prepare(literateDefinitionComment);
        this.postpare();
    }

    @Override
    public void visit(Require require) {
        this.prepare(require);
        if (!this.forEquivalence) {
            this.indenter.write("require \"" + require.getValue() + "\"");
            this.indenter.endLine();
        }
        this.postpare();
    }

    @Override
    public void visit(BackendTerm term) {
        this.prepare(term);
        this.indenter.write(term.getValue());
        this.postpare();
    }

    @Override
    public void visit(Bracket br) {
        this.prepare(br);
        this.indenter.write("(");
        br.getContent().accept(this);
        this.indenter.write(")");
        this.postpare();
    }

    @Override
    public void visit(Cast c) {
        this.prepare(c);
        c.getContent().accept(this);
        this.indenter.write(" :");
        if (c.isSyntactic()) {
            this.indenter.write(":");
        }
        this.indenter.write(c.getSort());
        this.postpare();
    }

    @Override
    public void visit(Token t) {
        this.prepare(t);
        this.indenter.write("#token(\"" + t.tokenSort() + "\", \"" + t.value() + "\")");
        this.postpare();
    }

    protected void prepare(ASTNode astNode) {
        if (!this.stack.empty() && this.needsParenthesis(this.stack.peek(), astNode)) {
            this.indenter.write("(");
        }
        this.stack.push(astNode);
        if (this.annotateLocation) {
            astNode.setLocation("(" + this.indenter.getLineNo() + "," + this.indenter.getColNo());
        }
    }

    protected void postpare() {
        String loc;
        ASTNode astNode = this.stack.pop();
        if (!this.stack.empty() && this.needsParenthesis(this.stack.peek(), astNode)) {
            this.indenter.write(")");
        }
        if (this.annotateLocation && !(loc = astNode.getLocation()).substring(loc.length() - 1).equals(")")) {
            astNode.setLocation(loc + "," + this.indenter.getLineNo() + "," + this.indenter.getColNo() + ")");
        }
    }

    private ArrayList<Terminal> findRightSyntax(String sort) {
        for (int i = 0; i < this.definition.getItems().size(); ++i) {
            if (!(this.definition.getItems().get(i) instanceof Module)) continue;
            for (int j = 0; j < ((Module)this.definition.getItems().get(i)).getItems().size(); ++j) {
                if (!(((Module)this.definition.getItems().get(i)).getItems().get(j) instanceof Syntax) || !((Syntax)((Module)this.definition.getItems().get(i)).getItems().get(j)).getSort().getName().equals(sort)) continue;
                for (int k = 0; k < ((Syntax)((Module)this.definition.getItems().get(i)).getItems().get(j)).getPriorityBlocks().size(); ++k) {
                    for (int l = 0; l < ((Syntax)((Module)this.definition.getItems().get(i)).getItems().get(j)).getPriorityBlocks().get(k).getProductions().size(); ++l) {
                        if (!((Syntax)((Module)this.definition.getItems().get(i)).getItems().get(j)).getPriorityBlocks().get(k).getProductions().get(l).containsAttribute(Attribute.BRACKET.getKey())) continue;
                        ArrayList<Terminal> result = new ArrayList<Terminal>();
                        int m = 0;
                        for (int n = 0; n < ((Syntax)((Module)this.definition.getItems().get(i)).getItems().get(j)).getPriorityBlocks().get(k).getProductions().get(l).getItems().size(); ++n) {
                            if (((Syntax)((Module)this.definition.getItems().get(i)).getItems().get(j)).getPriorityBlocks().get(k).getProductions().get(l).getItems().get(n) instanceof Terminal) {
                                result.add((Terminal)((Syntax)((Module)this.definition.getItems().get(i)).getItems().get(j)).getPriorityBlocks().get(k).getProductions().get(l).getItems().get(n));
                                ++m;
                            }
                            if (m != 2) continue;
                            return result;
                        }
                        return result;
                    }
                }
            }
        }
        return new ArrayList<Terminal>();
    }

    private boolean needsParenthesis(ASTNode upper, ASTNode astNode) {
        if (!this.addParentheses) {
            return false;
        }
        if (astNode instanceof Rewrite) {
            return !(upper instanceof Cell) && !(upper instanceof Rule);
        }
        if (astNode instanceof TermCons) {
            ArrayList<Terminal> isRightSyntax = this.findRightSyntax(((TermCons)astNode).getSort());
            return !isRightSyntax.isEmpty();
        }
        if (astNode instanceof TermCons && upper instanceof TermCons) {
            TermCons termConsNext = (TermCons)astNode;
            TermCons termCons = (TermCons)upper;
            Production productionNext = termConsNext.getProduction();
            Production production = termCons.getProduction();
            if (this.context.isPriorityWrong(production.getKLabel(), productionNext.getKLabel())) {
                return true;
            }
            return termConsNext.getContents().size() != 0;
        }
        return false;
    }

    public java.util.Map<Production, Integer> getPriorities() {
        return this.priorities;
    }

    public void setPriorities(java.util.Map<Production, Integer> priorities) {
        this.priorities = priorities;
    }

    public void setInConfiguration(boolean inConfiguration) {
        this.inConfiguration = inConfiguration;
    }
}

