/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.compile;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import org.kframework.compile.utils.BasicCompilerStep;
import org.kframework.compile.utils.MetaK;
import org.kframework.kil.Configuration;
import org.kframework.kil.Definition;
import org.kframework.kil.DefinitionItem;
import org.kframework.kil.Import;
import org.kframework.kil.Module;
import org.kframework.kil.ModuleItem;
import org.kframework.kil.loader.Context;
import org.kframework.kil.visitors.BasicVisitor;
import org.kframework.utils.errorsystem.KException;
import org.kframework.utils.general.GlobalSettings;

public class FlattenModules
extends BasicCompilerStep<Definition> {
    public FlattenModules(Context context) {
        super(context);
    }

    @Override
    public Definition compile(Definition def, String stepName) {
        FlattenModulesVisitor fm = new FlattenModulesVisitor(this.context);
        def.accept(fm);
        return fm.getResult();
    }

    @Override
    public String getName() {
        return "Flatten Modules";
    }

    private class FlattenModulesVisitor
    extends BasicVisitor {
        private final HashMap<String, Module> modules;
        private Definition result;

        public FlattenModulesVisitor(Context context) {
            super(context);
            this.modules = new HashMap();
        }

        @Override
        public void visit(Definition d) {
            this.result = new Definition(d);
            HashSet<String> included = new HashSet<String>();
            Configuration cfg = null;
            super.visit(d);
            this.result.setFilename(d.getFilename());
            this.result.setLocation(d.getLocation());
            this.result.setMainFile(d.getMainFile());
            this.result.setMainModule(d.getMainModule());
            this.result.setMainSyntaxModule(d.getMainModule());
            this.result.setItems(new ArrayList<DefinitionItem>());
            LinkedList<Module> mods = new LinkedList<Module>();
            Module rmod = new Module();
            rmod.setName(d.getMainModule());
            rmod.setItems(new ArrayList<ModuleItem>());
            this.result.getItems().add(rmod);
            mods.add(this.modules.remove(d.getMainModule()));
            while (!mods.isEmpty()) {
                Module mod = (Module)mods.remove();
                if (null == mod.getItems()) continue;
                for (ModuleItem i : mod.getItems()) {
                    if (i instanceof Import) {
                        String name = ((Import)i).getName();
                        if (included.contains(name)) continue;
                        if (!MetaK.isBuiltinModule(name)) {
                            if (this.modules.containsKey(name)) {
                                mods.add(this.modules.get(name));
                                included.add(name);
                                continue;
                            }
                            GlobalSettings.kem.register(new KException(KException.ExceptionType.WARNING, KException.KExceptionGroup.COMPILER, "Module " + name + " undefined.", this.getName(), i.getFilename(), i.getLocation()));
                            continue;
                        }
                        included.add(name);
                    }
                    if (i instanceof Configuration) {
                        if (null != cfg) continue;
                        cfg = (Configuration)i;
                        continue;
                    }
                    rmod.getItems().add(i);
                }
            }
            if (null != cfg) {
                rmod.getItems().add(cfg);
            }
        }

        @Override
        public void visit(Module m) {
            this.modules.put(m.getName(), m);
        }

        public Definition getResult() {
            return this.result;
        }
    }
}

