/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.compile.checks;

import org.kframework.kil.Configuration;
import org.kframework.kil.Context;
import org.kframework.kil.Rewrite;
import org.kframework.kil.Rule;
import org.kframework.kil.Syntax;
import org.kframework.kil.visitors.BasicVisitor;
import org.kframework.utils.errorsystem.KException;
import org.kframework.utils.general.GlobalSettings;

public class CheckRewrite
extends BasicVisitor {
    private boolean inConfig = false;
    private boolean inRewrite = false;
    private boolean inSideCondition = false;
    private int rewritesNo = 0;

    public CheckRewrite(org.kframework.kil.loader.Context context) {
        super(context);
    }

    @Override
    public void visit(Syntax node) {
    }

    @Override
    public void visit(Configuration node) {
        this.inConfig = true;
        super.visit(node);
        this.inConfig = false;
    }

    @Override
    public void visit(Rule node) {
        this.rewritesNo = 0;
        node.getBody().accept(this);
        if (this.rewritesNo == 0) {
            String msg = "Rules must have at least one rewrite.";
            GlobalSettings.kem.register(new KException(KException.ExceptionType.ERROR, KException.KExceptionGroup.COMPILER, msg, this.getName(), node.getFilename(), node.getLocation()));
        }
        if (node.getRequires() != null) {
            this.inSideCondition = true;
            node.getRequires().accept(this);
            this.inSideCondition = false;
        }
        if (node.getEnsures() != null) {
            this.inSideCondition = true;
            node.getEnsures().accept(this);
            this.inSideCondition = false;
        }
    }

    @Override
    public void visit(Context node) {
        node.getBody().accept(this);
        if (node.getRequires() != null) {
            this.inSideCondition = true;
            node.getRequires().accept(this);
            this.inSideCondition = false;
        }
        if (node.getEnsures() != null) {
            this.inSideCondition = true;
            node.getEnsures().accept(this);
            this.inSideCondition = false;
        }
    }

    @Override
    public void visit(Rewrite node) {
        String msg;
        if (this.inConfig) {
            msg = "Rewrites are not allowed in configurations.";
            GlobalSettings.kem.register(new KException(KException.ExceptionType.ERROR, KException.KExceptionGroup.COMPILER, msg, this.getName(), node.getFilename(), node.getLocation()));
        }
        if (this.inRewrite) {
            msg = "Rewrites are not allowed to be nested.";
            GlobalSettings.kem.register(new KException(KException.ExceptionType.ERROR, KException.KExceptionGroup.COMPILER, msg, this.getName(), node.getFilename(), node.getLocation()));
        }
        if (this.inSideCondition) {
            msg = "Rewrites are not allowed in side conditions.";
            GlobalSettings.kem.register(new KException(KException.ExceptionType.ERROR, KException.KExceptionGroup.COMPILER, msg, this.getName(), node.getFilename(), node.getLocation()));
        }
        ++this.rewritesNo;
        this.inRewrite = true;
        super.visit(node);
        this.inRewrite = false;
    }
}

