/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.compile.checks;

import org.kframework.kil.Sentence;
import org.kframework.kil.Syntax;
import org.kframework.kil.loader.Context;
import org.kframework.kil.visitors.BasicVisitor;
import org.kframework.utils.errorsystem.KException;
import org.kframework.utils.general.GlobalSettings;

public class CheckSortTopUniqueness
extends BasicVisitor {
    public CheckSortTopUniqueness(Context context) {
        super(context);
    }

    @Override
    public void visit(Syntax node) {
        String msg = "Multiple top sorts found for " + node.getSort() + ": ";
        int count = 0;
        if (this.context.isSubsorted("KList", node.getSort().getName())) {
            msg = msg + "KList, ";
            ++count;
        }
        if (this.context.isSubsorted("List", node.getSort().getName())) {
            msg = msg + "List, ";
            ++count;
        }
        if (this.context.isSubsorted("Bag", node.getSort().getName())) {
            msg = msg + "Bag, ";
            ++count;
        }
        if (this.context.isSubsorted("Map", node.getSort().getName())) {
            msg = msg + "Map, ";
            ++count;
        }
        if (this.context.isSubsorted("Set", node.getSort().getName())) {
            msg = msg + "Set, ";
            ++count;
        }
        if (count > 1) {
            msg = msg.substring(0, msg.length() - 2);
            GlobalSettings.kem.register(new KException(KException.ExceptionType.ERROR, KException.KExceptionGroup.COMPILER, msg, this.getName(), node.getFilename(), node.getLocation()));
        }
    }

    @Override
    public void visit(Sentence node) {
    }
}

