/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.compile.checks;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.kframework.kil.Production;
import org.kframework.kil.ProductionItem;
import org.kframework.kil.Sentence;
import org.kframework.kil.Sort;
import org.kframework.kil.Terminal;
import org.kframework.kil.UserList;
import org.kframework.kil.loader.Context;
import org.kframework.kil.visitors.BasicVisitor;
import org.kframework.utils.errorsystem.KException;
import org.kframework.utils.general.GlobalSettings;

public class CheckSyntaxDecl
extends BasicVisitor {
    Map<Production, Production> prods = new HashMap<Production, Production>();

    public CheckSyntaxDecl(Context context) {
        super(context);
    }

    @Override
    public void visit(Production node) {
        String msg;
        String sort;
        if (this.prods.containsKey(node)) {
            Production oldProd = this.prods.get(node);
            String msg2 = "Production has already been defined at " + oldProd.getLocation() + " in file " + oldProd.getFilename();
            GlobalSettings.kem.register(new KException(KException.ExceptionType.ERROR, KException.KExceptionGroup.COMPILER, msg2, this.getName(), node.getFilename(), node.getLocation()));
        } else {
            this.prods.put(node, node);
        }
        int sorts = 0;
        int neTerminals = 0;
        int eTerminals = 0;
        if (node.isSubsort() && Sort.isBasesort(sort = ((Sort)node.getItems().get(0)).getName()) && !this.context.isSubsorted(node.getSort(), sort)) {
            String msg3 = "Extending  built-in sorts is forbidden: K, KResult, KList, Map,\n\t MapItem, List, ListItem, Set, SetItem, Bag, BagItem, KLabel, CellLabel";
            GlobalSettings.kem.register(new KException(KException.ExceptionType.ERROR, KException.KExceptionGroup.COMPILER, msg3, this.getName(), node.getFilename(), node.getLocation()));
        }
        for (ProductionItem pi : node.getItems()) {
            String msg4;
            ProductionItem s;
            if (pi instanceof Sort) {
                ++sorts;
                s = (Sort)pi;
                if (!(((Sort)s).getName().endsWith("CellSort") || ((Sort)s).getName().endsWith("CellFragment") || ((Sort)s).getName().startsWith("#") || this.context.definedSorts.contains(((Sort)s).getName()))) {
                    msg4 = "Undefined sort " + ((Sort)s).getName();
                    GlobalSettings.kem.register(new KException(KException.ExceptionType.ERROR, KException.KExceptionGroup.COMPILER, msg4, this.getName(), s.getFilename(), s.getLocation()));
                }
                if (!(!((Sort)s).getName().equals("KResult") || node.isSubsort() && node.getSort().equals("K"))) {
                    msg4 = "KResult is only allowed in the left hand side of syntax.";
                    GlobalSettings.kem.register(new KException(KException.ExceptionType.ERROR, KException.KExceptionGroup.COMPILER, msg4, this.getName(), s.getFilename(), s.getLocation()));
                }
            }
            if (pi instanceof UserList) {
                ++sorts;
                s = (UserList)pi;
                if (!((UserList)s).getSort().startsWith("#") && !this.context.definedSorts.contains(((UserList)s).getSort())) {
                    msg4 = "Undefined sort " + ((UserList)s).getSort();
                    GlobalSettings.kem.register(new KException(KException.ExceptionType.ERROR, KException.KExceptionGroup.COMPILER, msg4, this.getName(), s.getFilename(), s.getLocation()));
                }
                if (((UserList)s).getSort().equals("KResult")) {
                    msg4 = "KResult is only allowed in the left hand side of syntax declarations.";
                    GlobalSettings.kem.register(new KException(KException.ExceptionType.ERROR, KException.KExceptionGroup.COMPILER, msg4, this.getName(), s.getFilename(), s.getLocation()));
                }
            }
            if (!(pi instanceof Terminal)) continue;
            Terminal t = (Terminal)pi;
            if (t.getTerminal().equals("")) {
                ++eTerminals;
                continue;
            }
            ++neTerminals;
        }
        if (!this.isBinaryInfixProd(node) && (node.containsAttribute("left") || node.containsAttribute("right") || node.containsAttribute("non-assoc"))) {
            msg = "Associativity attribute should only be assigned to binary infix production.\n";
            GlobalSettings.kem.register(new KException(KException.ExceptionType.WARNING, KException.KExceptionGroup.COMPILER, msg, this.getName(), node.getFilename(), node.getLocation()));
        }
        if (!(eTerminals <= 0 || neTerminals != 0 && sorts >= 2 || node.containsAttribute("onlyLabel") && node.containsAttribute("klabel"))) {
            msg = "Cannot declare empty terminals in the definition.\n";
            msg = msg + "            Use attribute 'onlyLabel' paired with 'klabel(...)' to limit the use to programs.";
            GlobalSettings.kem.register(new KException(KException.ExceptionType.ERROR, KException.KExceptionGroup.COMPILER, msg, this.getName(), node.getFilename(), node.getLocation()));
        }
    }

    @Override
    public void visit(Sentence node) {
    }

    private boolean isBinaryInfixProd(Production node) {
        if (node.getArity() != 2) {
            return false;
        }
        List<ProductionItem> prodItems = node.getItems();
        if (prodItems.size() == 2) {
            ProductionItem oprnd1 = node.getItems().get(0);
            ProductionItem oprnd2 = node.getItems().get(1);
            return oprnd1 instanceof Sort && oprnd2 instanceof Sort;
        }
        if (prodItems.size() == 3) {
            ProductionItem oprnd1 = node.getItems().get(0);
            ProductionItem op = node.getItems().get(1);
            ProductionItem oprnd2 = node.getItems().get(2);
            return oprnd1 instanceof Sort && oprnd2 instanceof Sort && op instanceof Terminal;
        }
        return false;
    }
}

