/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.compile.checks;

import java.util.HashMap;
import java.util.Map;
import org.kframework.compile.utils.MetaK;
import org.kframework.kil.Configuration;
import org.kframework.kil.Rewrite;
import org.kframework.kil.Sentence;
import org.kframework.kil.Syntax;
import org.kframework.kil.Term;
import org.kframework.kil.TermCons;
import org.kframework.kil.Variable;
import org.kframework.kil.loader.Context;
import org.kframework.kil.visitors.BasicVisitor;
import org.kframework.utils.errorsystem.KException;
import org.kframework.utils.general.GlobalSettings;

public class CheckVariables
extends BasicVisitor {
    public static final String UNBOUNDED_VARS = "hasUnboundedVars";
    HashMap<Variable, Integer> left = new HashMap();
    HashMap<Variable, Integer> right = new HashMap();
    HashMap<Variable, Integer> fresh = new HashMap();
    HashMap<Variable, Integer> current = this.left;
    boolean inCondition = false;

    public CheckVariables(Context context) {
        super(context);
    }

    @Override
    public void visit(Rewrite node) {
        node.getLeft().accept(this);
        this.current = this.right;
        node.getRight().accept(this);
        this.current = this.left;
    }

    @Override
    public void visit(Variable node) {
        Integer i;
        if (node.isFresh()) {
            if (this.current == this.right && !this.inCondition) {
                Integer i2 = this.fresh.get(node);
                i2 = i2 == null ? new Integer(1) : new Integer(i2);
                this.fresh.put(node, i2);
                return;
            }
            GlobalSettings.kem.register(new KException(KException.ExceptionType.ERROR, KException.KExceptionGroup.COMPILER, "Fresh variable \"" + node + "\" is bound in the " + "rule pattern.", this.getName(), node.getFilename(), node.getLocation()));
        }
        i = (i = this.current.remove(node)) == null ? new Integer(1) : new Integer(i + 1);
        this.current.put(node, i);
    }

    @Override
    public void visit(Configuration node) {
    }

    @Override
    public void visit(Syntax node) {
    }

    @Override
    public void visit(TermCons node) {
        Variable v;
        Term term;
        if (!node.getCons().equals("Bool1FreshSyn")) {
            super.visit(node);
            return;
        }
        if (!this.inCondition) {
            GlobalSettings.kem.register(new KException(KException.ExceptionType.ERROR, KException.KExceptionGroup.COMPILER, "Fresh can only be used in conditions.", this.getName(), node.getFilename(), node.getLocation()));
        }
        if (!((term = node.getContents().get(0)) instanceof Variable)) {
            GlobalSettings.kem.register(new KException(KException.ExceptionType.ERROR, KException.KExceptionGroup.COMPILER, "Fresh can only be applied to variables, but was applied to\n\t\t" + term, this.getName(), term.getFilename(), term.getLocation()));
        }
        if (this.left.containsKey(v = (Variable)term)) {
            for (Variable v1 : this.left.keySet()) {
                if (!v1.equals(v)) continue;
                GlobalSettings.kem.register(new KException(KException.ExceptionType.ERROR, KException.KExceptionGroup.COMPILER, "Fresh variable \"" + v1 + "\" is bound in the rule pattern.", this.getName(), v1.getFilename(), v1.getLocation()));
            }
        }
        this.left.put(v, new Integer(1));
    }

    @Override
    public void visit(Sentence node) {
        this.inCondition = false;
        this.left.clear();
        this.right.clear();
        this.fresh.clear();
        this.current = this.left;
        node.getBody().accept(this);
        if (node.getRequires() != null) {
            this.current = this.right;
            this.inCondition = true;
            node.getRequires().accept(this);
        }
        for (Variable variable : this.right.keySet()) {
            if (MetaK.isAnonVar(variable) && !variable.isFresh()) {
                GlobalSettings.kem.register(new KException(KException.ExceptionType.ERROR, KException.KExceptionGroup.COMPILER, "Anonymous variable found in the right hand side of a rewrite.", this.getName(), variable.getFilename(), variable.getLocation()));
            }
            if (this.left.containsKey(variable)) continue;
            node.addAttribute(UNBOUNDED_VARS, "");
            if (!GlobalSettings.javaBackend) {
                GlobalSettings.kem.register(new KException(KException.ExceptionType.ERROR, KException.KExceptionGroup.COMPILER, "Unbounded Variable " + variable.toString() + ".", this.getName(), variable.getFilename(), variable.getLocation()));
                continue;
            }
            GlobalSettings.kem.register(new KException(KException.ExceptionType.WARNING, KException.KExceptionGroup.COMPILER, "Unbounded Variable " + variable.toString() + ".", this.getName(), variable.getFilename(), variable.getLocation()));
        }
        for (Map.Entry entry : this.left.entrySet()) {
            Variable key = (Variable)entry.getKey();
            if (this.fresh.containsKey(key)) {
                GlobalSettings.kem.register(new KException(KException.ExceptionType.ERROR, KException.KExceptionGroup.COMPILER, "Variable " + key + " has the same name as a fresh " + "variable.", this.getName(), key.getFilename(), key.getLocation()));
            }
            if (MetaK.isAnonVar(key) || (Integer)entry.getValue() > 1 || this.right.containsKey(key)) continue;
            GlobalSettings.kem.register(new KException(KException.ExceptionType.HIDDENWARNING, KException.KExceptionGroup.COMPILER, "Singleton variable " + key.toString() + ".\n" + "    If this is not a spelling mistake, please consider using anonymous variables.", this.getName(), key.getFilename(), key.getLocation()));
        }
    }
}

