/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.compile.sharing;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import org.kframework.kil.DataStructureSort;
import org.kframework.kil.Production;
import org.kframework.kil.loader.Context;
import org.kframework.kil.visitors.BasicVisitor;

public class DataStructureSortCollector
extends BasicVisitor {
    private Map<String, String> types = new HashMap<String, String>();
    private Map<String, String> constructorLabels = new HashMap<String, String>();
    private Map<String, String> elementLabels = new HashMap<String, String>();
    private Map<String, String> unitLabels = new HashMap<String, String>();
    private Map<String, Map<String, String>> operatorLabels = new HashMap<String, Map<String, String>>();

    public DataStructureSortCollector(Context context) {
        super(context);
    }

    public Map<String, DataStructureSort> getSorts() {
        ImmutableMap.Builder<String, DataStructureSort> builder = ImmutableMap.builder();
        for (Map.Entry<String, String> entry : this.types.entrySet()) {
            String sort = entry.getKey();
            if (!this.constructorLabels.containsKey(sort) || !this.elementLabels.containsKey(sort) || !this.unitLabels.containsKey(sort)) continue;
            DataStructureSort dataStructureSort = new DataStructureSort(sort, this.types.get(sort), this.constructorLabels.get(sort), this.elementLabels.get(sort), this.unitLabels.get(sort), this.operatorLabels.get(sort));
            builder.put(sort, dataStructureSort);
        }
        return builder.build();
    }

    @Override
    public void visit(Production node) {
        Map labels;
        String sort = node.getSort();
        String hookAttribute = node.getAttribute("hook");
        if (hookAttribute == null) {
            return;
        }
        String[] strings = hookAttribute.split(":");
        if (strings.length != 2) {
            return;
        }
        String type = strings[0];
        String operator = strings[1];
        if (!DataStructureSort.TYPES.contains(type)) {
            return;
        }
        if (this.types.containsKey(sort)) {
            if (!this.types.get(sort).equals(type)) {
                return;
            }
        } else {
            this.types.put(sort, type);
            this.operatorLabels.put(sort, new HashMap());
        }
        if (operator.equals((labels = (Map)DataStructureSort.LABELS.get(type)).get((Object)DataStructureSort.Label.CONSTRUCTOR))) {
            if (this.constructorLabels.containsKey(sort)) {
                return;
            }
            this.constructorLabels.put(sort, node.getKLabel());
        } else if (operator.equals(labels.get((Object)DataStructureSort.Label.ELEMENT))) {
            if (this.elementLabels.containsKey(sort)) {
                return;
            }
            this.elementLabels.put(sort, node.getKLabel());
        } else if (operator.equals(labels.get((Object)DataStructureSort.Label.UNIT))) {
            if (this.unitLabels.containsKey(sort)) {
                return;
            }
            this.unitLabels.put(sort, node.getKLabel());
        } else {
            this.operatorLabels.get(sort).put(operator, node.getKLabel());
        }
    }
}

