/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.compile.sharing;

import java.util.HashMap;
import java.util.Map;
import org.kframework.kil.Rule;
import org.kframework.kil.Variable;
import org.kframework.kil.loader.Context;
import org.kframework.kil.visitors.BasicVisitor;
import org.kframework.kil.visitors.CopyOnWriteTransformer;
import org.kframework.kil.visitors.exceptions.TransformerException;

public class FreshVariableNormalizer
extends CopyOnWriteTransformer {
    private int counter;
    private Map<Variable, Variable> substitution = new HashMap<Variable, Variable>();
    private FreshVariableCounter visitor;

    public FreshVariableNormalizer(Context context) {
        super("Normalize fresh variable indices", context);
        this.visitor = new FreshVariableCounter(context);
    }

    @Override
    public Rule transform(Rule rule) {
        this.counter = 0;
        this.substitution.clear();
        rule.accept(this.visitor);
        if (this.substitution.isEmpty()) {
            return rule;
        }
        try {
            return (Rule)super.transform(rule);
        }
        catch (TransformerException e) {
            return rule;
        }
    }

    @Override
    public Variable transform(Variable variable) {
        Variable substituteVariable = this.substitution.get(variable);
        if (substituteVariable != null) {
            return substituteVariable;
        }
        return variable;
    }

    class FreshVariableCounter
    extends BasicVisitor {
        public FreshVariableCounter(Context context) {
            super(context);
        }

        @Override
        public void visit(Variable variable) {
            if (FreshVariableNormalizer.this.substitution.containsKey(variable)) {
                return;
            }
            if (variable.getName().startsWith("GeneratedFreshVar")) {
                try {
                    Integer.parseInt(variable.getName().substring("GeneratedFreshVar".length()));
                    FreshVariableNormalizer.this.substitution.put(variable, new Variable("GeneratedFreshVar" + FreshVariableNormalizer.this.counter++, variable.getSort()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

