/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.compile.sharing;

import java.util.HashSet;
import java.util.Set;
import org.kframework.kil.Configuration;
import org.kframework.kil.Context;
import org.kframework.kil.Definition;
import org.kframework.kil.Production;
import org.kframework.kil.Rule;
import org.kframework.kil.visitors.BasicVisitor;
import org.kframework.krun.K;
import org.kframework.utils.errorsystem.KException;
import org.kframework.utils.general.GlobalSettings;

public class TokenSortCollector
extends BasicVisitor {
    private final Set<String> tokenSorts = new HashSet<String>();
    private final Set<String> nonTokenSorts = new HashSet<String>();

    public static Set<String> collectTokenSorts(Definition definition, org.kframework.kil.loader.Context context) {
        TokenSortCollector collector = new TokenSortCollector(context);
        definition.accept(collector);
        return collector.tokenSorts;
    }

    private TokenSortCollector(org.kframework.kil.loader.Context context) {
        super(context);
    }

    @Override
    public void visit(Production production) {
        if (GlobalSettings.javaBackend || K.backend.equals("java")) {
            this.checkIllegalProduction(production);
        } else if (production.isLexical() && !production.containsAttribute("variable")) {
            this.tokenSorts.add(production.getSort());
        }
    }

    private void checkIllegalProduction(Production production) {
        String msg;
        String sort = production.getSort();
        if (production.isLexical() && !production.containsAttribute("variable")) {
            if (this.nonTokenSorts.contains(sort)) {
                msg = "Cannot subsort a lexical production to a non-token sort:\nsyntax " + sort + " ::= " + production;
                GlobalSettings.kem.register(new KException(KException.ExceptionType.ERROR, KException.KExceptionGroup.COMPILER, msg, production.getFilename(), production.getLocation()));
            }
            this.tokenSorts.add(sort);
        }
        if (!production.isLexical() && !production.containsAttribute("function")) {
            if (this.tokenSorts.contains(sort)) {
                msg = "Cannot subsort a non-lexical production to a token sort:\nsyntax " + sort + " ::= " + production;
                GlobalSettings.kem.register(new KException(KException.ExceptionType.ERROR, KException.KExceptionGroup.COMPILER, msg, production.getFilename(), production.getLocation()));
            }
            this.nonTokenSorts.add(sort);
        }
    }

    @Override
    public void visit(Rule node) {
    }

    @Override
    public void visit(Context node) {
    }

    @Override
    public void visit(Configuration node) {
    }
}

