/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.compile.transformers;

import java.util.ArrayList;
import org.kframework.kil.ASTNode;
import org.kframework.kil.KApp;
import org.kframework.kil.ListTerminator;
import org.kframework.kil.Production;
import org.kframework.kil.ProductionItem;
import org.kframework.kil.Sort;
import org.kframework.kil.Term;
import org.kframework.kil.TermCons;
import org.kframework.kil.Token;
import org.kframework.kil.UserList;
import org.kframework.kil.loader.Context;
import org.kframework.kil.visitors.BasicTransformer;
import org.kframework.kil.visitors.exceptions.TransformerException;
import org.kframework.utils.errorsystem.KException;
import org.kframework.utils.general.GlobalSettings;

public class AddEmptyLists
extends BasicTransformer {
    public AddEmptyLists(Context context) {
        super("Add empty lists", context);
    }

    @Override
    public ASTNode transform(TermCons tc) throws TransformerException {
        Production p = tc.getProduction();
        if (p.isListDecl()) {
            String msg;
            Term t = tc.getContents().get(0);
            UserList ul = (UserList)p.getItems().get(0);
            if (this.isAddEmptyList(ul.getSort(), t.getSort())) {
                if (!this.isUserListElement(ul.getSort(), t, this.context)) {
                    msg = "Found sort '" + t.getSort() + "' where list sort '" + ul.getSort() + "' was expected. Moving on.";
                    GlobalSettings.kem.register(new KException(KException.ExceptionType.HIDDENWARNING, KException.KExceptionGroup.LISTS, msg, t.getFilename(), t.getLocation()));
                } else {
                    tc.getContents().set(0, this.addEmpty(t, ul.getSort()));
                }
            }
            t = tc.getContents().get(1);
            if (this.isAddEmptyList(p.getSort(), t.getSort())) {
                if (!this.isUserListElement(p.getSort(), t, this.context)) {
                    msg = "Found sort '" + t.getSort() + "' where list sort '" + p.getSort() + "' was expected. Moving on.";
                    GlobalSettings.kem.register(new KException(KException.ExceptionType.HIDDENWARNING, KException.KExceptionGroup.LISTS, msg, t.getFilename(), t.getLocation()));
                } else {
                    tc.getContents().set(1, this.addEmpty(t, tc.getProduction().getSort()));
                }
            }
        } else {
            int i = 0;
            for (int j = 0; j < p.getItems().size(); ++j) {
                Term t;
                ProductionItem pi = p.getItems().get(j);
                if (!(pi instanceof Sort)) continue;
                String srt = ((Sort)pi).getName();
                if (this.context.isListSort(srt) && this.isAddEmptyList(srt, (t = tc.getContents().get(i)).getSort())) {
                    if (!this.isUserListElement(srt, t, this.context)) {
                        String msg = "Found sort '" + t.getSort() + "' where list sort '" + srt + "' was expected. Moving on.";
                        GlobalSettings.kem.register(new KException(KException.ExceptionType.HIDDENWARNING, KException.KExceptionGroup.LISTS, msg, t.getFilename(), t.getLocation()));
                    } else {
                        tc.getContents().set(i, this.addEmpty(t, srt));
                    }
                }
                ++i;
            }
        }
        return super.transform(tc);
    }

    private boolean isUserListElement(String listSort, Term element, Context context) {
        String elementSort = element.getSort();
        if (elementSort.equals("KItem") && element instanceof KApp && ((KApp)element).getLabel() instanceof Token) {
            elementSort = ((Token)((KApp)element).getLabel()).tokenSort();
        }
        return !elementSort.equals("KItem") && context.isSubsortedEq(listSort, elementSort);
    }

    public boolean isAddEmptyList(String expectedSort, String termSort) {
        if (!this.context.isListSort(expectedSort)) {
            return false;
        }
        return !this.context.isSubsortedEq(expectedSort, termSort) || !this.context.isListSort(termSort);
    }

    private Term addEmpty(Term node, String sort) {
        TermCons tc = new TermCons(sort, this.getListCons(sort), this.context);
        ArrayList<Term> genContents = new ArrayList<Term>();
        genContents.add(node);
        genContents.add(new ListTerminator(sort, null));
        tc.setContents(genContents);
        return tc;
    }

    private String getListCons(String psort) {
        Production p = this.context.listConses.get(psort);
        return p.getAttribute("cons");
    }
}

