/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.compile.transformers;

import java.util.Set;
import org.kframework.compile.transformers.AddPredicates;
import org.kframework.compile.utils.MetaK;
import org.kframework.kil.ASTNode;
import org.kframework.kil.BoolBuiltin;
import org.kframework.kil.Configuration;
import org.kframework.kil.Context;
import org.kframework.kil.KApp;
import org.kframework.kil.KLabel;
import org.kframework.kil.KLabelConstant;
import org.kframework.kil.KSequence;
import org.kframework.kil.Rewrite;
import org.kframework.kil.Rule;
import org.kframework.kil.Syntax;
import org.kframework.kil.Term;
import org.kframework.kil.Variable;
import org.kframework.kil.visitors.CopyOnWriteTransformer;
import org.kframework.kil.visitors.exceptions.TransformerException;
import org.kframework.utils.errorsystem.KException;
import org.kframework.utils.general.GlobalSettings;

public class AddHeatingConditions
extends CopyOnWriteTransformer {
    public AddHeatingConditions(org.kframework.kil.loader.Context context) {
        super("Generate Heating Conditions", context);
    }

    @Override
    public ASTNode transform(Configuration node) throws TransformerException {
        return node;
    }

    @Override
    public ASTNode transform(Context node) throws TransformerException {
        return node;
    }

    @Override
    public ASTNode transform(Rule node) throws TransformerException {
        KSequence kSequence;
        boolean heating = node.containsAttribute("heat");
        boolean cooling = node.containsAttribute("cool");
        if (!heating && !cooling) {
            return node;
        }
        KApp kresultCnd = null;
        if (!(node.getBody() instanceof Rewrite)) {
            GlobalSettings.kem.register(new KException(KException.ExceptionType.ERROR, KException.KExceptionGroup.CRITICAL, "Heating/Cooling rules should have rewrite at the top.", this.getName(), node.getFilename(), node.getLocation()));
        }
        Rewrite rewrite = (Rewrite)node.getBody();
        if (heating) {
            if (!(rewrite.getRight() instanceof KSequence)) {
                GlobalSettings.kem.register(new KException(KException.ExceptionType.ERROR, KException.KExceptionGroup.CRITICAL, "Heating rules should have a K sequence in the rhs.", this.getName(), node.getFilename(), node.getLocation()));
            }
            kSequence = (KSequence)rewrite.getRight();
        } else {
            if (!(rewrite.getLeft() instanceof KSequence)) {
                GlobalSettings.kem.register(new KException(KException.ExceptionType.ERROR, KException.KExceptionGroup.CRITICAL, "Cooling rules should have a K sequence in the lhs.", this.getName(), node.getFilename(), node.getLocation()));
            }
            kSequence = (KSequence)rewrite.getLeft();
        }
        if (kSequence.getContents().size() != 2) {
            GlobalSettings.kem.register(new KException(KException.ExceptionType.ERROR, KException.KExceptionGroup.CRITICAL, "Heating/Cooling rules should have exactly 2 items in their K Sequence.", this.getName(), node.getFilename(), node.getLocation()));
        }
        Term term = null;
        if (!GlobalSettings.testgen) {
            Set<Variable> vars = kSequence.getContents().get(0).variables();
            if (vars.size() != 1) {
                GlobalSettings.kem.register(new KException(KException.ExceptionType.ERROR, KException.KExceptionGroup.CRITICAL, "Heating/Cooling rules should heat/cool at most one variable.", this.getName(), node.getFilename(), node.getLocation()));
            }
            Variable variable = vars.iterator().next();
            term = variable;
        } else {
            term = kSequence.getContents().get(0);
        }
        String resultType = node.getAttribute("result");
        KLabel resultLabel = this.getResultLabel(resultType);
        KApp isKResult = KApp.of(resultLabel, term);
        kresultCnd = heating ? KApp.of(KLabelConstant.KNEQ_KLABEL, isKResult, BoolBuiltin.TRUE) : isKResult;
        node = node.shallowCopy();
        Term condition = MetaK.incrementCondition(node.getRequires(), kresultCnd);
        node.setRequires(condition);
        return node;
    }

    private KLabel getResultLabel(String resultType) {
        if (resultType == null) {
            return KLabelConstant.KRESULT_PREDICATE;
        }
        if (Character.isUpperCase(resultType.charAt(0))) {
            return KLabelConstant.of(AddPredicates.predicate(resultType));
        }
        return KLabelConstant.of(resultType);
    }

    @Override
    public ASTNode transform(Syntax node) throws TransformerException {
        return node;
    }
}

