/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.compile.transformers;

import java.util.ArrayList;
import java.util.Collections;
import org.kframework.kil.ASTNode;
import org.kframework.kil.Definition;
import org.kframework.kil.KApp;
import org.kframework.kil.KItemProjection;
import org.kframework.kil.KLabelInjection;
import org.kframework.kil.PriorityBlock;
import org.kframework.kil.Production;
import org.kframework.kil.Rewrite;
import org.kframework.kil.Rule;
import org.kframework.kil.Sort;
import org.kframework.kil.Syntax;
import org.kframework.kil.Term;
import org.kframework.kil.TermCons;
import org.kframework.kil.loader.Context;
import org.kframework.kil.visitors.CopyOnWriteTransformer;
import org.kframework.kil.visitors.exceptions.TransformerException;

public class AddInjections
extends CopyOnWriteTransformer {
    private TransformationState state;

    public AddInjections(Context context) {
        super("", context);
    }

    @Override
    public Definition transform(Definition definition) throws TransformerException {
        this.state = TransformationState.TRANSFORM_PRODUCTIONS;
        definition = (Definition)super.transform(definition);
        this.state = TransformationState.TRANSFORM_TERMS;
        definition = (Definition)super.transform(definition);
        this.state = TransformationState.REMOVE_REDUNDANT_INJECTIONS;
        definition = (Definition)super.transform(definition);
        return definition;
    }

    @Override
    public Syntax transform(Syntax node) throws TransformerException {
        Syntax returnNode;
        if (this.state != TransformationState.TRANSFORM_PRODUCTIONS) {
            return node;
        }
        if (node.getPriorityBlocks().size() != 1 || node.getPriorityBlocks().get(0).getProductions().size() != 1) {
            return node;
        }
        assert (node.getPriorityBlocks().size() == 1);
        assert (node.getPriorityBlocks().get(0).getProductions().size() == 1);
        String sort = node.getSort().getName();
        Production production = node.getPriorityBlocks().get(0).getProductions().get(0);
        production = (Production)this.transform(production);
        if (sort.equals("KLabel") && production.containsAttribute("function") || sort.equals("K") || sort.equals("KList")) {
            production = production.shallowCopy();
            production.setSort("KItem");
        }
        if (production != node.getPriorityBlocks().get(0).getProductions().get(0)) {
            String cons = (String)this.context.conses.inverse().get(node.getPriorityBlocks().get(0).getProductions().get(0));
            this.context.conses.forcePut(cons, production);
            returnNode = node.shallowCopy();
            PriorityBlock priorityBlock = node.getPriorityBlocks().get(0).shallowCopy();
            returnNode.setPriorityBlocks(Collections.singletonList(priorityBlock));
            priorityBlock.setProductions(Collections.singletonList(production));
            if (!production.getSort().equals(sort)) {
                returnNode.setSort(returnNode.getSort().shallowCopy());
                returnNode.getSort().setName(production.getSort());
            }
        } else {
            returnNode = node;
        }
        return returnNode;
    }

    @Override
    public Sort transform(Sort node) {
        assert (this.state == TransformationState.TRANSFORM_PRODUCTIONS);
        if (node.getName().equals("KLabel") || node.getName().equals("KList")) {
            Sort returnNode = node.shallowCopy();
            returnNode.setName("KItem");
            return returnNode;
        }
        return node;
    }

    @Override
    public Rule transform(Rule node) throws TransformerException {
        if (node.containsAttribute("nojava")) {
            return node;
        }
        if (this.state != TransformationState.TRANSFORM_TERMS) {
            return node;
        }
        Rule transformedNode = (Rule)super.transform(node);
        if (!node.containsAttribute("function")) {
            return transformedNode;
        }
        assert (transformedNode.getBody() instanceof Rewrite) : "Deep rewrites are currently not allowed in function rules.";
        Term left = ((Rewrite)transformedNode.getBody()).getLeft();
        Term right = ((Rewrite)transformedNode.getBody()).getRight();
        if (!(left instanceof KItemProjection)) {
            return transformedNode;
        }
        transformedNode = transformedNode.shallowCopy();
        Rewrite transformedBody = (Rewrite)transformedNode.getBody().shallowCopy();
        transformedNode.setBody(transformedBody);
        transformedBody.setLeft(((KItemProjection)left).getTerm(), this.context);
        transformedBody.setRight(KApp.of(new KLabelInjection(right), new Term[0]), this.context);
        return transformedNode;
    }

    @Override
    public ASTNode transform(TermCons node) throws TransformerException {
        TermCons transformedNode;
        if (this.state != TransformationState.TRANSFORM_TERMS) {
            return node;
        }
        if (node.getSort().equals("List") || node.getSort().equals("ListItem") || node.getSort().equals("Map") || node.getSort().equals("MapItem") || node.getSort().equals("Set") || node.getSort().equals("SetItem")) {
            return node;
        }
        boolean change = false;
        ArrayList<Term> transformedContents = new ArrayList<Term>();
        for (Term term : node.getContents()) {
            Term transformedTerm = (Term)term.accept(this);
            assert (transformedTerm != null);
            if (transformedTerm.getSort().equals("KLabel") || transformedTerm.getSort().equals("KList")) {
                transformedTerm = KApp.of(new KLabelInjection(transformedTerm), new Term[0]);
            }
            transformedContents.add(transformedTerm);
            if (transformedTerm == term) continue;
            change = true;
        }
        if (change) {
            transformedNode = node.shallowCopy();
            transformedNode.setContents(transformedContents);
        } else {
            transformedNode = node;
        }
        String sort = node.getProduction().getSort();
        if (sort.equals("K") || sort.equals("KLabel") || sort.equals("KList")) {
            transformedNode.setSort("KItem");
            if (node.getProduction().getLabel().equals("#if_#then_#else_#fi") && !sort.equals("KList")) {
                return transformedNode;
            }
            return new KItemProjection(sort, transformedNode);
        }
        return transformedNode;
    }

    private static enum TransformationState {
        TRANSFORM_PRODUCTIONS,
        TRANSFORM_TERMS,
        REMOVE_REDUNDANT_INJECTIONS;

    }
}

