/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.compile.transformers;

import java.util.ArrayList;
import org.kframework.compile.transformers.AddSymbolicK;
import org.kframework.compile.utils.MetaK;
import org.kframework.compile.utils.SyntaxByTag;
import org.kframework.kil.ASTNode;
import org.kframework.kil.Attribute;
import org.kframework.kil.KApp;
import org.kframework.kil.KLabelConstant;
import org.kframework.kil.Module;
import org.kframework.kil.ModuleItem;
import org.kframework.kil.Production;
import org.kframework.kil.Rule;
import org.kframework.kil.StringBuiltin;
import org.kframework.kil.Term;
import org.kframework.kil.TermCons;
import org.kframework.kil.Variable;
import org.kframework.kil.loader.Context;
import org.kframework.kil.visitors.CopyOnWriteTransformer;
import org.kframework.kil.visitors.exceptions.TransformerException;

public class AddK2SMTLib
extends CopyOnWriteTransformer {
    public static final KLabelConstant K_TO_SMTLIB = KLabelConstant.of("K2SMTLib");
    public static final String SMTLIB_ATTR = "smtlib";
    private static final String SMTLIB_VAR_PREFIX = "__var__";

    public static Term appendString(Term term1, Term term2, Context context) {
        return KApp.of(KLabelConstant.STRING_PLUSSTRING_KLABEL, term1, term2);
    }

    @Override
    public ASTNode transform(Module node) throws TransformerException {
        Module retNode = node.shallowCopy();
        retNode.setItems(new ArrayList<ModuleItem>(node.getItems()));
        retNode.addConstant(K_TO_SMTLIB);
        for (String sort : node.getAllSorts()) {
            if (!AddSymbolicK.allowKSymbolic(sort)) continue;
            String symCtor = AddSymbolicK.symbolicConstructor(sort);
            Variable var = Variable.getFreshVar("Int");
            KApp symTerm = KApp.of(KLabelConstant.of(symCtor, this.context), var);
            KApp lhs = KApp.of(K_TO_SMTLIB, symTerm);
            KApp strTerm = KApp.of(KLabelConstant.of("Int2String", this.context), var);
            Term rhs = AddK2SMTLib.appendString(StringBuiltin.kAppOf(SMTLIB_VAR_PREFIX), strTerm, this.context);
            Rule rule = new Rule(lhs, rhs, this.context);
            rule.addAttribute(Attribute.FUNCTION);
            retNode.appendModuleItem(rule);
            var = Variable.getFreshVar("#String");
            symTerm = KApp.of(KLabelConstant.of(symCtor, this.context), var);
            lhs = KApp.of(K_TO_SMTLIB, symTerm);
            rhs = AddK2SMTLib.appendString(StringBuiltin.kAppOf(SMTLIB_VAR_PREFIX), var, this.context);
            rule = new Rule(lhs, rhs, this.context);
            rule.addAttribute(Attribute.FUNCTION);
            retNode.appendModuleItem(rule);
            var = Variable.getFreshVar("Id");
            symTerm = KApp.of(KLabelConstant.of(symCtor, this.context), var);
            lhs = KApp.of(K_TO_SMTLIB, symTerm);
            strTerm = KApp.of(KLabelConstant.of("#tokenToString", this.context), var);
            rhs = AddK2SMTLib.appendString(StringBuiltin.kAppOf(SMTLIB_VAR_PREFIX), strTerm, this.context);
            rule = new Rule(lhs, rhs, this.context);
            rule.addAttribute(Attribute.FUNCTION);
            retNode.appendModuleItem(rule);
            var = Variable.getFreshVar("#Id");
            symTerm = KApp.of(KLabelConstant.of(symCtor, this.context), var);
            lhs = KApp.of(K_TO_SMTLIB, symTerm);
            strTerm = KApp.of(KLabelConstant.of("#tokenToString", this.context), var);
            rhs = AddK2SMTLib.appendString(StringBuiltin.kAppOf(SMTLIB_VAR_PREFIX), strTerm, this.context);
            rule = new Rule(lhs, rhs, this.context);
            rule.addAttribute(Attribute.FUNCTION);
            retNode.appendModuleItem(rule);
        }
        for (Production prod : SyntaxByTag.get(node, SMTLIB_ATTR, this.context)) {
            Term rhs;
            String smtLbl = prod.getAttribute(SMTLIB_ATTR);
            if (smtLbl == null) {
                smtLbl = "";
            }
            if (smtLbl.equals("")) {
                smtLbl = prod.getLabel();
            }
            if (prod.isSubsort() || prod.isListDecl()) continue;
            Term term = MetaK.getTerm(prod, this.context);
            KApp lhs = KApp.of(K_TO_SMTLIB, term);
            if (prod.isConstant()) {
                rhs = StringBuiltin.kAppOf(smtLbl);
            } else {
                TermCons termCons = (TermCons)term;
                rhs = StringBuiltin.kAppOf("(" + smtLbl);
                for (int idx = 0; idx < ((TermCons)term).arity(); ++idx) {
                    Variable var = (Variable)termCons.getSubterm(idx);
                    rhs = AddK2SMTLib.appendString(rhs, StringBuiltin.SPACE, this.context);
                    rhs = AddK2SMTLib.appendString(rhs, KApp.of(K_TO_SMTLIB, var), this.context);
                }
                rhs = AddK2SMTLib.appendString(rhs, StringBuiltin.kAppOf(")"), this.context);
            }
            Rule rule = new Rule(lhs, rhs, this.context);
            rule.addAttribute(Attribute.FUNCTION);
            retNode.appendModuleItem(rule);
        }
        return retNode;
    }

    public AddK2SMTLib(Context context) {
        super("Add translation from K to Z3 SMTlib v2 string", context);
    }
}

