/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.compile.transformers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.kframework.compile.utils.MetaK;
import org.kframework.kil.ASTNode;
import org.kframework.kil.Bag;
import org.kframework.kil.Cell;
import org.kframework.kil.Configuration;
import org.kframework.kil.KSequence;
import org.kframework.kil.Module;
import org.kframework.kil.ModuleItem;
import org.kframework.kil.Rule;
import org.kframework.kil.loader.Context;
import org.kframework.kil.visitors.CopyOnWriteTransformer;
import org.kframework.kil.visitors.exceptions.TransformerException;

public class AddKCell
extends CopyOnWriteTransformer {
    protected List<String> komputationCells = new ArrayList<String>();
    protected List<ModuleItem> newRules;

    public AddKCell(Context context) {
        super("Add K cell", context);
        if (context.getKomputationCells() == null) {
            this.komputationCells.add("k");
        } else {
            this.komputationCells = context.getKomputationCells();
        }
        assert (!this.komputationCells.isEmpty());
    }

    @Override
    public ASTNode transform(Module module) throws TransformerException {
        Module returnModule;
        this.newRules = new ArrayList<ModuleItem>();
        Module newModule = (Module)super.transform(module);
        if (this.newRules.isEmpty()) {
            returnModule = newModule;
        } else {
            returnModule = newModule.shallowCopy();
            returnModule = returnModule.addModuleItems(this.newRules);
        }
        return returnModule;
    }

    @Override
    public ASTNode transform(Rule node) {
        List<String> computationCells;
        if (MetaK.isAnywhere(node)) {
            return node;
        }
        if (!MetaK.isComputationSort(node.getBody().getSort())) {
            return node;
        }
        String computationCellsAttr = (node = node.shallowCopy()).getAttribute("cell");
        if (computationCellsAttr != null) {
            computationCells = new ArrayList<String>();
            Collections.addAll(computationCells, computationCellsAttr.split(","));
        } else {
            computationCells = this.komputationCells;
        }
        for (int i = 1; i < computationCells.size(); ++i) {
            Rule newRule = node.shallowCopy();
            newRule.setBody(MetaK.kWrap(node.getBody(), this.komputationCells.get(i)));
            this.newRules.add(newRule);
        }
        assert (!computationCells.isEmpty());
        node.setBody(MetaK.kWrap(node.getBody(), computationCells.get(0)));
        return node;
    }

    @Override
    public ASTNode transform(Configuration cfg) throws TransformerException {
        if (!AddKCell.intersects(MetaK.getAllCellLabels(cfg.getBody(), this.context), this.komputationCells)) {
            Bag bag;
            if ((cfg = cfg.shallowCopy()).getBody() instanceof Bag) {
                bag = (Bag)cfg.getBody().shallowCopy();
            } else {
                bag = new Bag();
                bag.getContents().add(cfg.getBody());
            }
            cfg.setBody(bag);
            for (String kCell : this.komputationCells) {
                Cell k = new Cell();
                k.setLabel(kCell);
                k.setEllipses(Cell.Ellipses.NONE);
                k.setContents(KSequence.EMPTY);
                bag.getContents().add(k);
            }
        }
        return cfg;
    }

    private static boolean intersects(List<String> l1, List<String> l2) {
        for (String s1 : l1) {
            if (!l2.contains(s1)) continue;
            return true;
        }
        return false;
    }
}

