/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.compile.transformers;

import java.util.ArrayList;
import org.kframework.compile.transformers.AddPredicates;
import org.kframework.kil.ASTNode;
import org.kframework.kil.Attribute;
import org.kframework.kil.BoolBuiltin;
import org.kframework.kil.KApp;
import org.kframework.kil.KInjectedLabel;
import org.kframework.kil.KLabelConstant;
import org.kframework.kil.Module;
import org.kframework.kil.ModuleItem;
import org.kframework.kil.Rule;
import org.kframework.kil.Term;
import org.kframework.kil.loader.Context;
import org.kframework.kil.visitors.CopyOnWriteTransformer;
import org.kframework.kil.visitors.exceptions.TransformerException;

public class AddKLabelConstant
extends CopyOnWriteTransformer {
    private static final KLabelConstant KLabelConstantPredicate = KLabelConstant.of(AddPredicates.predicate("KLabelConstant"));

    public AddKLabelConstant(Context context) {
        super("Define isKLabelConstant predicate for KLabel constants", context);
    }

    @Override
    public ASTNode transform(Module node) throws TransformerException {
        Module retNode = node.shallowCopy();
        retNode.setItems(new ArrayList<ModuleItem>(node.getItems()));
        retNode.addConstant(KLabelConstantPredicate);
        for (String klbl : node.getModuleKLabels()) {
            KApp kapp = KApp.of(new KInjectedLabel(KLabelConstant.of(klbl, this.context)), new Term[0]);
            KApp lhs = KApp.of(KLabelConstantPredicate, kapp);
            KApp rhs = BoolBuiltin.TRUE;
            Rule rule = new Rule(lhs, rhs, this.context);
            rule.addAttribute(Attribute.PREDICATE);
            retNode.appendModuleItem(rule);
        }
        if (retNode.getItems().size() != node.getItems().size()) {
            return retNode;
        }
        return node;
    }
}

