/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.compile.transformers;

import java.util.ArrayList;
import org.kframework.kil.ASTNode;
import org.kframework.kil.Attribute;
import org.kframework.kil.KApp;
import org.kframework.kil.KInjectedLabel;
import org.kframework.kil.KLabelConstant;
import org.kframework.kil.Module;
import org.kframework.kil.ModuleItem;
import org.kframework.kil.Rule;
import org.kframework.kil.StringBuiltin;
import org.kframework.kil.Term;
import org.kframework.kil.TermCons;
import org.kframework.kil.loader.Context;
import org.kframework.kil.visitors.CopyOnWriteTransformer;
import org.kframework.kil.visitors.exceptions.TransformerException;
import org.kframework.utils.StringUtil;

public class AddKStringConversion
extends CopyOnWriteTransformer {
    private static final KLabelConstant KLabel2String = KLabelConstant.of("KLabel2String");
    private static final String String2KLabelCons = "KLabel1String2KLabelSyn";

    public AddKStringConversion(Context context) {
        super("Define KLabel2String and String2Klabel for KLabel constants", context);
    }

    @Override
    public ASTNode transform(Module node) throws TransformerException {
        Module retNode = node.shallowCopy();
        retNode.setItems(new ArrayList<ModuleItem>(node.getItems()));
        for (String klbl : node.getModuleKLabels()) {
            KApp kapp = KApp.of(new KInjectedLabel(KLabelConstant.of(klbl, this.context)), new Term[0]);
            KApp lhs = KApp.of(KLabel2String, kapp);
            KApp rhs = StringBuiltin.kAppOf(StringUtil.escapeMaude(klbl));
            Rule rule = new Rule(lhs, rhs, this.context);
            rule.addAttribute(Attribute.FUNCTION);
            retNode.appendModuleItem(rule);
            ArrayList<Term> termList = new ArrayList<Term>();
            termList.add(rhs);
            TermCons termCons = new TermCons("KLabel", String2KLabelCons, termList, this.context);
            rule = new Rule(termCons, KLabelConstant.of(klbl, this.context), this.context);
            rule.addAttribute(Attribute.FUNCTION);
            retNode.appendModuleItem(rule);
        }
        if (retNode.getItems().size() != node.getItems().size()) {
            return retNode;
        }
        return node;
    }
}

