/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.compile.transformers;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.kframework.compile.transformers.AddSymbolicK;
import org.kframework.compile.utils.MetaK;
import org.kframework.kil.ASTNode;
import org.kframework.kil.Attribute;
import org.kframework.kil.BoolBuiltin;
import org.kframework.kil.Configuration;
import org.kframework.kil.Context;
import org.kframework.kil.KApp;
import org.kframework.kil.KInjectedLabel;
import org.kframework.kil.KLabelConstant;
import org.kframework.kil.ListTerminator;
import org.kframework.kil.Module;
import org.kframework.kil.ModuleItem;
import org.kframework.kil.Production;
import org.kframework.kil.Rule;
import org.kframework.kil.StringBuiltin;
import org.kframework.kil.Syntax;
import org.kframework.kil.Term;
import org.kframework.kil.Variable;
import org.kframework.kil.visitors.BasicVisitor;
import org.kframework.kil.visitors.CopyOnWriteTransformer;
import org.kframework.kil.visitors.exceptions.TransformerException;

public class AddPredicates
extends CopyOnWriteTransformer {
    public static final KLabelConstant K2Sort = KLabelConstant.of("K2Sort");
    private static final String PredicatePrefix = "is";
    private static final String SymbolicPredicatePrefix = "Symbolic";
    public static final KLabelConstant BuiltinPredicate = KLabelConstant.of(AddPredicates.predicate("Builtin"));
    public static final KLabelConstant VariablePredicate = KLabelConstant.of(AddPredicates.predicate("Variable"));
    public static final KLabelConstant KSymbolicPredicate = KLabelConstant.of(AddPredicates.symbolicPredicate("K"));

    public static final String predicate(String sort) {
        return PredicatePrefix + sort;
    }

    public static final String syntaxPredicate(String sort) {
        assert (!MetaK.isKSort(sort)) : "invalid syntactic predicate " + AddPredicates.predicate(sort) + " for sort " + sort;
        return AddPredicates.predicate(sort);
    }

    public static final String symbolicPredicate(String sort) {
        assert (AddSymbolicK.allowSymbolic(sort)) : "invalid symbolic predicate " + AddPredicates.predicate("Symbolic" + sort) + " for sort " + sort;
        return AddPredicates.predicate(SymbolicPredicatePrefix + sort);
    }

    @Override
    public ASTNode transform(Module node) throws TransformerException {
        Module retNode = node.shallowCopy();
        retNode.setItems(new ArrayList<ModuleItem>(node.getItems()));
        retNode.addConstant(BuiltinPredicate);
        retNode.addConstant(KSymbolicPredicate);
        for (String sort : node.getAllSorts()) {
            if (MetaK.isKSort(sort)) continue;
            String pred = AddPredicates.syntaxPredicate(sort);
            retNode.addConstant("KLabel", pred);
            if (AddSymbolicK.allowKSymbolic(sort)) {
                String symPred = AddPredicates.symbolicPredicate(sort);
                retNode.addConstant("KLabel", symPred);
                Variable var = Variable.getFreshVar("K");
                KApp lhs = KApp.of(KLabelConstant.of(symPred, this.context), var);
                KApp rhs = KApp.of(KLabelConstant.BOOL_ANDTHENBOOL_KLABEL, KApp.of(KLabelConstant.of(pred, this.context), var), KApp.of(KSymbolicPredicate, var));
                Rule rule = new Rule(lhs, rhs, this.context);
                rule.addAttribute(Attribute.PREDICATE);
                retNode.appendModuleItem(rule);
                String symCtor = AddSymbolicK.symbolicConstructor(sort);
                var = Variable.getFreshVar("KList");
                KApp symTerm = KApp.of(KLabelConstant.of(symCtor, this.context), var);
                lhs = KApp.of(KLabelConstant.of(pred, this.context), symTerm);
                rule = new Rule(lhs, BoolBuiltin.TRUE, this.context);
                rule.addAttribute(Attribute.PREDICATE);
                retNode.appendModuleItem(rule);
                rule = AddPredicates.getIsVariableRule(symTerm, this.context);
                retNode.appendModuleItem(rule);
                lhs = KApp.of(K2Sort, symTerm);
                rhs = StringBuiltin.kAppOf(sort);
                rule = new Rule(lhs, rhs, this.context);
                rule.addAttribute(Attribute.FUNCTION);
                retNode.appendModuleItem(rule);
                continue;
            }
            if (MetaK.isBuiltinSort(sort)) {
                Variable var = Variable.getFreshVar(sort);
                KApp lhs = KApp.of(BuiltinPredicate, var);
                Rule rule = new Rule(lhs, BoolBuiltin.TRUE, this.context);
                rule.addAttribute(Attribute.PREDICATE);
                retNode.appendModuleItem(rule);
                continue;
            }
            if (!this.context.getTokenSorts().contains(sort)) continue;
        }
        for (String sort : this.context.getDataStructureSorts().keySet()) {
            retNode.addConstant("KLabel", AddPredicates.predicate(sort));
        }
        PredicatesVisitor mv = new PredicatesVisitor("PredicatesVisitor", this.context);
        node.accept(mv);
        retNode.getItems().addAll(mv.getResult());
        if (retNode.getItems().size() != node.getItems().size()) {
            return retNode;
        }
        return node;
    }

    public static Rule getIsVariableRule(Term symTerm, org.kframework.kil.loader.Context context) {
        if (!MetaK.isComputationSort(symTerm.getSort())) {
            symTerm = KApp.of(new KInjectedLabel(symTerm), new Term[0]);
        }
        KApp lhs = KApp.of(VariablePredicate, symTerm);
        Rule rule = new Rule(lhs, BoolBuiltin.TRUE, context);
        rule.addAttribute(Attribute.PREDICATE);
        return rule;
    }

    public AddPredicates(org.kframework.kil.loader.Context context) {
        super("Add syntax and symbolic predicates", context);
    }

    public class PredicatesVisitor
    extends BasicVisitor {
        private List<ModuleItem> result;
        private Set<String> lists;

        public PredicatesVisitor(String name, org.kframework.kil.loader.Context context) {
            super(name, context);
            this.result = new ArrayList<ModuleItem>();
            this.lists = new HashSet<String>();
        }

        @Override
        public void visit(Module node) {
            this.lists.clear();
            super.visit(node);
            if (!this.lists.isEmpty()) {
                for (String listSort : this.lists) {
                    Rule rule = new Rule(KApp.of(KLabelConstant.of(AddPredicates.predicate(listSort), this.context), new ListTerminator(listSort, null)), BoolBuiltin.TRUE, this.context);
                    rule.addAttribute(Attribute.PREDICATE);
                    this.result.add(rule);
                    rule = new Rule(KApp.of(KLabelConstant.KRESULT_PREDICATE, new ListTerminator(listSort, null)), BoolBuiltin.TRUE, this.context);
                    rule.addAttribute(Attribute.PREDICATE);
                    this.result.add(rule);
                }
            }
        }

        @Override
        public void visit(Syntax node) {
            String sort = node.getSort().getName();
            if (this.context.isListSort(sort)) {
                this.lists.add(sort);
            }
            if (MetaK.isKSort(sort)) {
                return;
            }
            super.visit(node);
        }

        @Override
        public void visit(Production node) {
            if (node.containsAttribute("bracket")) {
                return;
            }
            if (node.containsAttribute("predicate")) {
                return;
            }
            if (node.isLexical()) {
                return;
            }
            if (this.context.getDataStructureSorts().containsKey(node.getSort())) {
                return;
            }
            String sort = node.getSort();
            Term term = MetaK.getTerm(node, this.context);
            KApp rhs = node.containsAttribute("function") && node.getArity() > 0 ? KApp.of(KSymbolicPredicate, term) : BoolBuiltin.TRUE;
            KApp lhs = KApp.of(KLabelConstant.of(AddPredicates.syntaxPredicate(sort), this.context), term);
            Rule rule = new Rule(lhs, rhs, this.context);
            rule.addAttribute(Attribute.PREDICATE);
            this.result.add(rule);
            if (!node.isSubsort()) {
                lhs = KApp.of(K2Sort, term);
                rhs = StringBuiltin.kAppOf(sort);
                rule = new Rule(lhs, rhs, this.context);
                rule.addAttribute(Attribute.FUNCTION);
                this.result.add(rule);
            }
        }

        @Override
        public void visit(Rule node) {
        }

        @Override
        public void visit(Context node) {
        }

        @Override
        public void visit(Configuration node) {
        }

        public List<ModuleItem> getResult() {
            return this.result;
        }
    }
}

