/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.compile.transformers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.kframework.compile.transformers.AddPredicates;
import org.kframework.compile.utils.MetaK;
import org.kframework.kil.ASTNode;
import org.kframework.kil.Attribute;
import org.kframework.kil.KApp;
import org.kframework.kil.KInjectedLabel;
import org.kframework.kil.KLabelConstant;
import org.kframework.kil.KList;
import org.kframework.kil.Module;
import org.kframework.kil.ModuleItem;
import org.kframework.kil.Production;
import org.kframework.kil.Rule;
import org.kframework.kil.Term;
import org.kframework.kil.Variable;
import org.kframework.kil.loader.Context;
import org.kframework.kil.visitors.CopyOnWriteTransformer;
import org.kframework.kil.visitors.exceptions.TransformerException;
import org.kframework.utils.errorsystem.KException;
import org.kframework.utils.general.GlobalSettings;

public class AddSemanticEquality
extends CopyOnWriteTransformer {
    public static final String EQUALITY_SORT = "EqualitySort";
    public static final KLabelConstant EQUALITY_PREDICATE = KLabelConstant.of(AddPredicates.predicate("EqualitySort"));
    private Map<String, String> equalities = new HashMap<String, String>();

    @Override
    public ASTNode transform(Module node) throws TransformerException {
        Module retNode = node.shallowCopy();
        retNode.setItems(new ArrayList<ModuleItem>(node.getItems()));
        Set<Production> eqProds = node.getSyntaxByTag(Attribute.EQUALITY.getKey(), this.context);
        for (Production production : eqProds) {
            if (!production.getSort().equals("Bool")) continue;
            if (production.getArity() == 2) {
                if (production.getChildSort(0).equals(production.getChildSort(1))) {
                    if (!this.equalities.containsKey(production.getChildSort(0))) {
                        this.equalities.put(production.getChildSort(0), production.getKLabel());
                        continue;
                    }
                    GlobalSettings.kem.register(new KException(KException.ExceptionType.ERROR, KException.KExceptionGroup.CRITICAL, "redeclaration of equality for sort " + production.getChildSort(0), production.getFilename(), production.getLocation()));
                    continue;
                }
                GlobalSettings.kem.register(new KException(KException.ExceptionType.ERROR, KException.KExceptionGroup.CRITICAL, "arguments for equality expected to be of the same sort", production.getFilename(), production.getLocation()));
                continue;
            }
            GlobalSettings.kem.register(new KException(KException.ExceptionType.ERROR, KException.KExceptionGroup.CRITICAL, "unexpected number of arguments for equality, expected 2", production.getFilename(), production.getLocation()));
        }
        retNode.addConstant(EQUALITY_PREDICATE);
        for (Map.Entry entry : this.equalities.entrySet()) {
            String sort = (String)entry.getKey();
            KLabelConstant sortEq = KLabelConstant.of((String)entry.getValue(), this.context);
            if (!MetaK.isComputationSort(sort)) continue;
            retNode.addSubsort(EQUALITY_SORT, sort, this.context);
            KList kList = new KList();
            kList.add(Variable.getFreshVar(sort));
            kList.add(Variable.getFreshVar(sort));
            KApp lhs = new KApp(KLabelConstant.KEQ, kList);
            KApp rhs = new KApp(sortEq, kList);
            Rule rule = new Rule(lhs, rhs, this.context);
            rule.addAttribute(Attribute.FUNCTION);
            retNode.appendModuleItem(rule);
        }
        Set<Production> prods = node.getSyntaxByTag("", this.context);
        for (Production prod : prods) {
            if (prod.isSubsort() || prod.containsAttribute(Attribute.BRACKET.getKey()) || prod.containsAttribute(Attribute.FUNCTION.getKey()) || prod.containsAttribute(Attribute.PREDICATE.getKey()) || MetaK.isKSort(prod.getSort()) && !prod.getSort().equals("K")) continue;
            Variable KListVar1 = Variable.getFreshVar("KList");
            Variable KListVar2 = Variable.getFreshVar("KList");
            KList lhsList = new KList();
            lhsList.add(new KApp(KLabelConstant.of(prod.getKLabel(), this.context), KListVar1));
            lhsList.add(new KApp(KLabelConstant.of(prod.getKLabel(), this.context), KListVar2));
            KList rhsList = new KList();
            rhsList.add(KApp.of(new KInjectedLabel(KListVar1), new Term[0]));
            rhsList.add(KApp.of(new KInjectedLabel(KListVar2), new Term[0]));
            KApp lhs = new KApp(KLabelConstant.KEQ, lhsList);
            KApp rhs = new KApp(KLabelConstant.KLIST_EQUALITY, rhsList);
            Rule rule = new Rule(lhs, rhs, this.context);
            rule.addAttribute(Attribute.FUNCTION);
            retNode.appendModuleItem(rule);
        }
        for (String sort : this.context.getTokenSorts()) {
            KList kList = new KList();
            kList.add(Variable.getFreshVar(sort));
            kList.add(Variable.getFreshVar(sort));
            KApp lhs = new KApp(KLabelConstant.KEQ, kList);
            KApp rhs = new KApp(KLabelConstant.KEQ_KLABEL, kList);
            Rule rule = new Rule(lhs, rhs, this.context);
            rule.addAttribute(Attribute.FUNCTION);
            retNode.appendModuleItem(rule);
        }
        return retNode;
    }

    public AddSemanticEquality(Context context) {
        super("Define semantic equality", context);
    }
}

