/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.compile.transformers;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.kframework.compile.utils.MetaK;
import org.kframework.kil.ASTNode;
import org.kframework.kil.Attributes;
import org.kframework.kil.Cell;
import org.kframework.kil.Configuration;
import org.kframework.kil.Context;
import org.kframework.kil.DataStructureSort;
import org.kframework.kil.Module;
import org.kframework.kil.Rule;
import org.kframework.kil.Syntax;
import org.kframework.kil.visitors.CopyOnWriteTransformer;
import org.kframework.kil.visitors.exceptions.TransformerException;
import org.kframework.utils.errorsystem.KException;
import org.kframework.utils.general.GlobalSettings;

public class AddStreamCells
extends CopyOnWriteTransformer {
    List<Rule> generated = new ArrayList<Rule>();

    public AddStreamCells(org.kframework.kil.loader.Context context) {
        super("Add cells to stream rules", context);
    }

    @Override
    public ASTNode transform(Module node) throws TransformerException {
        ASTNode result = super.transform(node);
        if (result == node) {
            return node;
        }
        if (this.generated.isEmpty()) {
            return result;
        }
        result = result.shallowCopy();
        ((Module)result).getItems().addAll(this.generated);
        return result;
    }

    @Override
    public ASTNode transform(Configuration node) throws TransformerException {
        return node;
    }

    @Override
    public ASTNode transform(Context node) throws TransformerException {
        return node;
    }

    @Override
    public ASTNode transform(Syntax node) throws TransformerException {
        return node;
    }

    @Override
    public ASTNode transform(Rule node) throws TransformerException {
        boolean isStream = false;
        if (node.getAttributes().containsKey("stdin")) {
            isStream = true;
            this.addRules(node, "stdin");
        }
        if (node.getAttributes().containsKey("stdout")) {
            isStream = true;
            this.addRules(node, "stdout");
        }
        if (node.getAttributes().containsKey("stderr")) {
            isStream = true;
            this.addRules(node, "stderr");
        }
        if (isStream) {
            return null;
        }
        return node;
    }

    private void addRules(Rule rule, String stream) {
        DataStructureSort sort = this.context.dataStructureSortOf(rule.getBody().getSort());
        if (!rule.getBody().getSort().equals("List") && !rule.getBody().getSort().equals("ListItem") && this.context.dataStructureListSortOf(rule.getBody().getSort()) == null) {
            GlobalSettings.kem.register(new KException(KException.ExceptionType.ERROR, KException.KExceptionGroup.INTERNAL, "Found a rule tagged '" + stream + "' whose body wasn't a list.", this.getName(), rule.getFilename(), rule.getLocation()));
        }
        HashSet<Cell> cells = new HashSet<Cell>();
        for (String cellName : this.context.cells.keySet()) {
            Cell cell = this.context.cells.get(cellName);
            if (!stream.equals(cell.getCellAttributes().get("stream"))) continue;
            cells.add(cell);
        }
        for (Cell cell : cells) {
            Rule newRule = rule.shallowCopy();
            Attributes newAttrs = newRule.getAttributes().shallowCopy();
            newAttrs.remove("function");
            newRule.setAttributes(newAttrs);
            newRule.setBody(MetaK.wrap(rule.getBody(), cell.getLabel(), Cell.Ellipses.NONE));
            this.generated.add(newRule);
        }
    }
}

