/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.compile.transformers;

import java.util.ArrayList;
import java.util.List;
import org.kframework.kil.ASTNode;
import org.kframework.kil.Attributes;
import org.kframework.kil.Configuration;
import org.kframework.kil.Context;
import org.kframework.kil.KApp;
import org.kframework.kil.KLabelConstant;
import org.kframework.kil.KSequence;
import org.kframework.kil.Module;
import org.kframework.kil.ModuleItem;
import org.kframework.kil.Rewrite;
import org.kframework.kil.Rule;
import org.kframework.kil.Syntax;
import org.kframework.kil.Term;
import org.kframework.kil.visitors.CopyOnWriteTransformer;
import org.kframework.kil.visitors.exceptions.TransformerException;
import org.kframework.utils.errorsystem.KException;
import org.kframework.utils.general.GlobalSettings;

public class AddSupercoolDefinition
extends CopyOnWriteTransformer {
    private List<Rule> superCools = new ArrayList<Rule>();

    public AddSupercoolDefinition(org.kframework.kil.loader.Context context) {
        super("AddSupercoolDefinition", context);
    }

    @Override
    public ASTNode transform(Module node) throws TransformerException {
        this.superCools.clear();
        node = (Module)super.transform(node);
        if (!this.superCools.isEmpty()) {
            node = node.shallowCopy();
            node.setItems(new ArrayList<ModuleItem>(node.getItems()));
            node.getItems().addAll(this.superCools);
        }
        return node;
    }

    @Override
    public ASTNode transform(Configuration node) throws TransformerException {
        return node;
    }

    @Override
    public ASTNode transform(Context node) throws TransformerException {
        return node;
    }

    @Override
    public ASTNode transform(Rule node) throws TransformerException {
        KSequence kSequence;
        List<Term> kSequenceContents;
        Rewrite rewrite;
        if (!node.containsAttribute("cool")) {
            return node;
        }
        if (!(node.getBody() instanceof Rewrite)) {
            GlobalSettings.kem.register(new KException(KException.ExceptionType.ERROR, KException.KExceptionGroup.CRITICAL, "Cooling rules should have rewrite at the top.", this.getName(), node.getFilename(), node.getLocation()));
        }
        if (!((rewrite = (Rewrite)node.getBody()).getLeft() instanceof KSequence)) {
            GlobalSettings.kem.register(new KException(KException.ExceptionType.ERROR, KException.KExceptionGroup.CRITICAL, "Cooling rules should have a K sequence in the lhs.", this.getName(), node.getFilename(), node.getLocation()));
        }
        if ((kSequenceContents = (kSequence = (KSequence)rewrite.getLeft()).getContents()).size() != 2) {
            GlobalSettings.kem.register(new KException(KException.ExceptionType.ERROR, KException.KExceptionGroup.CRITICAL, "Heating/Cooling rules should have exactly 2 items in their K Sequence.", this.getName(), node.getFilename(), node.getLocation()));
        }
        Term cool = kSequenceContents.get(0);
        kSequenceContents = new ArrayList<Term>(kSequenceContents);
        kSequenceContents.set(0, KApp.of(KLabelConstant.COOL_KLABEL, cool));
        kSequence = kSequence.shallowCopy();
        kSequence.setContents(kSequenceContents);
        rewrite = rewrite.shallowCopy();
        rewrite.replaceChildren(kSequence, KApp.of(KLabelConstant.COOL_KLABEL, rewrite.getRight()), this.context);
        Rule superCoolNode = node.shallowCopy();
        Attributes attrs = new Attributes();
        attrs.getContents().addAll(node.getAttributes().getContents());
        attrs.remove("cool");
        superCoolNode.setAttributes(attrs);
        superCoolNode.setBody(rewrite);
        this.superCools.add(superCoolNode);
        return node;
    }

    @Override
    public ASTNode transform(Syntax node) throws TransformerException {
        return node;
    }
}

