/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.compile.transformers;

import java.util.ArrayList;
import java.util.List;
import org.kframework.compile.utils.MetaK;
import org.kframework.kil.ASTNode;
import org.kframework.kil.BoolBuiltin;
import org.kframework.kil.Configuration;
import org.kframework.kil.Context;
import org.kframework.kil.KApp;
import org.kframework.kil.KInjectedLabel;
import org.kframework.kil.KLabelConstant;
import org.kframework.kil.KList;
import org.kframework.kil.KSequence;
import org.kframework.kil.Module;
import org.kframework.kil.ModuleItem;
import org.kframework.kil.Rewrite;
import org.kframework.kil.Rule;
import org.kframework.kil.Syntax;
import org.kframework.kil.Term;
import org.kframework.kil.Variable;
import org.kframework.kil.visitors.CopyOnWriteTransformer;
import org.kframework.kil.visitors.exceptions.TransformerException;
import org.kframework.utils.errorsystem.KException;
import org.kframework.utils.general.GlobalSettings;

public class AddSuperheatRules
extends CopyOnWriteTransformer {
    List<ModuleItem> superHeats = new ArrayList<ModuleItem>();

    public AddSuperheatRules(org.kframework.kil.loader.Context context) {
        super("Add Superheat rules", context);
    }

    @Override
    public ASTNode transform(Module node) throws TransformerException {
        this.superHeats.clear();
        node = (Module)super.transform(node);
        if (!this.superHeats.isEmpty()) {
            node = node.shallowCopy();
            node.setItems(new ArrayList<ModuleItem>(node.getItems()));
            node.getItems().addAll(this.superHeats);
        }
        return node;
    }

    @Override
    public ASTNode transform(Configuration node) throws TransformerException {
        return node;
    }

    @Override
    public ASTNode transform(Context node) throws TransformerException {
        return node;
    }

    @Override
    public ASTNode transform(Rule node) throws TransformerException {
        if (!node.containsAttribute("heat")) {
            return node;
        }
        boolean superheat = false;
        for (String heat : GlobalSettings.superheat) {
            if (!node.containsAttribute(heat)) continue;
            superheat = true;
            break;
        }
        if (!(node.getBody() instanceof Rewrite)) {
            GlobalSettings.kem.register(new KException(KException.ExceptionType.ERROR, KException.KExceptionGroup.CRITICAL, "Heating rules should have rewrite at the top.", this.getName(), node.getFilename(), node.getLocation()));
        }
        Rewrite body = (Rewrite)node.getBody();
        if (!superheat) {
            KSequence kSequence = new KSequence();
            kSequence.getContents().add(body);
            kSequence.add(new Variable("_", "K"));
            KApp redex = KApp.of(KLabelConstant.REDEX_KLABEL, kSequence);
            KApp heat = KApp.of(KLabelConstant.HEAT_KLABEL, redex, new Variable("_", "KList"));
            Rule superHeat = node.shallowCopy();
            superHeat.setBody(heat);
            this.superHeats.add(superHeat);
            return node;
        }
        Rule superHeat = node.shallowCopy();
        Term left = body.getLeft();
        Term right = body.getRight();
        Variable restHeat = Variable.getFreshVar("K");
        Variable lHeat = Variable.getFreshVar("KList");
        KSequence red1Seq = new KSequence();
        red1Seq.add(left);
        red1Seq.add(restHeat);
        KList red1List = new KList();
        red1List.add(red1Seq);
        red1List.add(lHeat);
        KSequence red2Seq = new KSequence();
        KList red2List = new KList();
        red2List.add(red2Seq);
        red2Seq.getContents().addAll(((KSequence)right).getContents());
        red2Seq.add(restHeat);
        KApp red2 = new KApp(KLabelConstant.REDEX_KLABEL, red2List);
        Rewrite red2rew = new Rewrite(KList.EMPTY, red2, this.context);
        red1List.add(red2rew);
        KApp red1 = new KApp(KLabelConstant.REDEX_KLABEL, red1List);
        KList heatList = new KList();
        heatList.add(red1);
        heatList.add(new Variable("_", "KList"));
        KApp heat = new KApp(KLabelConstant.HEAT_KLABEL, heatList);
        superHeat.setBody(heat);
        KList inListList = new KList();
        inListList.add(red2);
        inListList.add(KApp.of(new KInjectedLabel(lHeat), new Term[0]));
        KApp inList = new KApp(KLabelConstant.of("'_inKList_", this.context), inListList);
        KList condList = new KList();
        condList.add(inList);
        condList.add(BoolBuiltin.TRUE);
        KApp cond = new KApp(KLabelConstant.KNEQ_KLABEL, condList);
        superHeat.setRequires(MetaK.incrementCondition(node.getRequires(), cond));
        this.superHeats.add(superHeat);
        node = node.shallowCopy();
        KApp red3 = KApp.of(KLabelConstant.REDEX_KLABEL, left);
        KList red3List = new KList();
        red3List.add(red3);
        red3List.add(KApp.of(KLabelConstant.HEATED_KLABEL, new Term[0]));
        KApp heat2 = new KApp(KLabelConstant.HEAT_KLABEL, red3List);
        node.setBody(new Rewrite(left, heat2, this.context));
        return node;
    }

    @Override
    public ASTNode transform(Syntax node) throws TransformerException {
        return node;
    }
}

