/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.compile.transformers;

import java.util.ArrayList;
import org.kframework.compile.utils.MetaK;
import org.kframework.kil.ASTNode;
import org.kframework.kil.IntBuiltin;
import org.kframework.kil.KApp;
import org.kframework.kil.KLabelConstant;
import org.kframework.kil.Module;
import org.kframework.kil.ModuleItem;
import org.kframework.kil.Production;
import org.kframework.kil.StringBuiltin;
import org.kframework.kil.Term;
import org.kframework.kil.TermCons;
import org.kframework.kil.loader.Context;
import org.kframework.kil.visitors.CopyOnWriteTransformer;
import org.kframework.kil.visitors.exceptions.TransformerException;

public class AddSymbolicK
extends CopyOnWriteTransformer {
    private static final String SymbolicConstructorPrefix = "#sym";

    public AddSymbolicK(Context context) {
        super("Add symbolic constructors", context);
    }

    public static final boolean allowSymbolic(String sort) {
        return sort.equals("List") || sort.equals("Set") || sort.equals("Bag") || sort.equals("Map") || AddSymbolicK.allowKSymbolic(sort);
    }

    public static final boolean allowKSymbolic(String sort) {
        return MetaK.isComputationSort(sort) && !MetaK.isBuiltinSort(sort);
    }

    public static final String symbolicConstructor(String sort) {
        assert (AddSymbolicK.allowSymbolic(sort));
        return SymbolicConstructorPrefix + sort;
    }

    public static final boolean isSymbolicConstructor(String sort) {
        return sort.startsWith(SymbolicConstructorPrefix);
    }

    public final Production getSymbolicProduction(String sort) {
        assert (AddSymbolicK.allowSymbolic(sort));
        return Production.makeFunction(sort, AddSymbolicK.symbolicConstructor(sort), "K", this.context);
    }

    public final Term makeSymbolicTerm(String sort, Term term) {
        Term symTerm;
        assert (AddSymbolicK.allowSymbolic(sort));
        String ctor = AddSymbolicK.symbolicConstructor(sort);
        if (!AddSymbolicK.allowKSymbolic(sort)) {
            symTerm = new TermCons(sort, ctor, this.context);
            symTerm.getContents().add(term);
        } else {
            symTerm = KApp.of(KLabelConstant.of(ctor, this.context), term);
        }
        return symTerm;
    }

    public Term freshSymSortN(String sort, int n) {
        return KApp.of(KLabelConstant.of("'#freshSymSortN", this.context), StringBuiltin.kAppOf(sort), IntBuiltin.kAppOf(n));
    }

    @Override
    public ASTNode transform(Module node) throws TransformerException {
        Module retNode = node.shallowCopy();
        retNode.setItems(new ArrayList<ModuleItem>(node.getItems()));
        for (String sort : node.getAllSorts()) {
            if (!AddSymbolicK.allowKSymbolic(sort)) continue;
            retNode.addConstant("KLabel", AddSymbolicK.symbolicConstructor(sort));
        }
        if (retNode.getItems().size() != node.getItems().size()) {
            return retNode;
        }
        return node;
    }

    public static String getSymbolicConstructorPrefix() {
        return SymbolicConstructorPrefix;
    }
}

