/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.compile.transformers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.kframework.compile.utils.CellMap;
import org.kframework.compile.utils.ConfigurationStructure;
import org.kframework.kil.ASTNode;
import org.kframework.kil.Bag;
import org.kframework.kil.Cell;
import org.kframework.kil.CellDataStructure;
import org.kframework.kil.CellList;
import org.kframework.kil.Configuration;
import org.kframework.kil.DataStructureBuiltin;
import org.kframework.kil.DataStructureSort;
import org.kframework.kil.ListBuiltin;
import org.kframework.kil.MapBuiltin;
import org.kframework.kil.Term;
import org.kframework.kil.Variable;
import org.kframework.kil.loader.Context;
import org.kframework.kil.visitors.CopyOnWriteTransformer;
import org.kframework.kil.visitors.exceptions.TransformerException;

public class Cell2DataStructure
extends CopyOnWriteTransformer {
    public static final String LIST_CELL_ATTRIBUTE_NAME = "list";
    public static final String MAP_CELL_ATTRIBUTE_NAME = "map";
    public static final String KEY_CELL_ATTRIBUTE_NAME = "key";

    public Cell2DataStructure(Context context) {
        super("Transform cells with key attribute to maps", context);
    }

    @Override
    public ASTNode transform(Configuration configuration) {
        return configuration;
    }

    @Override
    public ASTNode transform(Cell cell) throws TransformerException {
        DataStructureBuiltin dataStructureBuiltin;
        this.makeCellDataStructures();
        CellDataStructure cellDataStructure = this.context.cellDataStructures.get(cell.getLabel());
        if (cellDataStructure == null) {
            return super.transform(cell);
        }
        Bag cellContent = this.normalizeCellContent(cell.getContents());
        if (cellDataStructure instanceof CellList) {
            dataStructureBuiltin = this.getListBuiltin(cellContent, (CellList)cellDataStructure);
        } else if (cellDataStructure instanceof CellMap) {
            dataStructureBuiltin = this.getMapBuiltin(cellContent, (CellMap)cellDataStructure);
        } else {
            assert (false);
            return null;
        }
        Cell returnCell = cell.shallowCopy();
        returnCell.setContents(dataStructureBuiltin);
        return returnCell;
    }

    private Bag normalizeCellContent(Term content) {
        if (content instanceof Bag) {
            return Bag.flatten((Bag)content);
        }
        if (content instanceof Cell || content instanceof Variable) {
            return new Bag(Collections.singletonList(content));
        }
        assert (false);
        return null;
    }

    private ListBuiltin getListBuiltin(Bag cellContent, CellList cellList) {
        Term term;
        int rightIndex;
        Term term2;
        int leftIndex;
        DataStructureSort listSort = this.context.dataStructureSortOf("MyList");
        List<Term> cellItems = cellContent.getContents();
        ArrayList<Term> elementsLeft = new ArrayList<Term>();
        for (leftIndex = 0; leftIndex < cellItems.size() && (term2 = cellItems.get(leftIndex)) instanceof Cell; ++leftIndex) {
            Cell elementCell = (Cell)term2;
            assert (elementCell.getLabel().equals(cellList.elementCellLabel()));
            elementsLeft.add(elementCell);
        }
        ArrayList<Term> elementsRight = new ArrayList<Term>();
        for (rightIndex = cellItems.size() - 1; rightIndex >= leftIndex && (term = cellItems.get(rightIndex)) instanceof Cell; --rightIndex) {
            Cell elementCell = (Cell)term;
            assert (elementCell.getLabel().equals(cellList.elementCellLabel()));
            elementsRight.add(elementCell);
        }
        ArrayList<Term> terms = new ArrayList<Term>();
        for (int index = leftIndex; index <= rightIndex; ++index) {
            Term term3 = cellItems.get(index);
            if (term3 instanceof Cell) {
                terms.add(term3);
                continue;
            }
            if (term3 instanceof Variable) {
                terms.add(new Variable(((Variable)term3).getName(), listSort.name()));
                continue;
            }
            assert (false);
        }
        return new ListBuiltin(listSort, terms, elementsLeft, elementsRight);
    }

    private MapBuiltin getMapBuiltin(Bag cellContent, CellMap cellMap) {
        DataStructureSort mapSort = this.context.dataStructureSortOf("MyMap");
        HashMap<Term, Term> entries = new HashMap<Term, Term>();
        ArrayList<Term> terms = new ArrayList<Term>();
        for (Term term : cellContent.getContents()) {
            if (term instanceof Cell) {
                Cell entryCell = (Cell)term;
                assert (entryCell.getLabel().equals(cellMap.entryCellLabel()));
                Bag entryCellContent = this.normalizeCellContent(entryCell.getContents());
                Term key = null;
                Cell value = new Cell();
                value.setLabel("value_cell_label_prefix_" + entryCell.getLabel());
                value.setEndLabel("value_cell_label_prefix_" + entryCell.getLabel());
                Bag valueContent = new Bag();
                value.setContents(valueContent);
                for (Term entryCellTerm : entryCellContent.getContents()) {
                    if (entryCellTerm instanceof Cell && ((Cell)entryCellTerm).getLabel().equals(cellMap.keyCellLabel())) {
                        assert (key == null) : "there should be exactly one key cell";
                        key = ((Cell)entryCellTerm).getContents();
                        continue;
                    }
                    valueContent.add(entryCellTerm);
                }
                assert (key != null) : "there should be exactly one key cell";
                entries.put(key, value);
                continue;
            }
            if (term instanceof Variable) {
                terms.add(new Variable(((Variable)term).getName(), mapSort.name()));
                continue;
            }
            assert (false);
        }
        return new MapBuiltin(mapSort, terms, entries);
    }

    private void makeCellDataStructures() {
        for (ConfigurationStructure cell : this.context.getConfigurationStructureMap().values()) {
            this.makeCellDataStructure(cell);
        }
    }

    private void makeCellDataStructure(ConfigurationStructure configurationStructure) {
        if (configurationStructure.cell.containsCellAttribute(LIST_CELL_ATTRIBUTE_NAME)) {
            String listCellLabel = configurationStructure.id;
            if (configurationStructure.sons.size() != 1) {
                assert (false);
                return;
            }
            ConfigurationStructure elementConfigurationStructure = configurationStructure.sons.values().iterator().next();
            String elementCellLabel = elementConfigurationStructure.id;
            this.context.cellDataStructures.put(listCellLabel, new CellList(listCellLabel, elementCellLabel));
        } else if (configurationStructure.cell.containsCellAttribute(MAP_CELL_ATTRIBUTE_NAME)) {
            String mapCellLabel = configurationStructure.id;
            if (configurationStructure.sons.size() != 1) {
                assert (false);
                return;
            }
            ConfigurationStructure entryConfigurationStructure = configurationStructure.sons.values().iterator().next();
            String entryCellLabel = entryConfigurationStructure.id;
            ConfigurationStructure keyConfigurationStructure = null;
            for (ConfigurationStructure child : entryConfigurationStructure.sons.values()) {
                if (!child.cell.containsCellAttribute(KEY_CELL_ATTRIBUTE_NAME)) continue;
                if (keyConfigurationStructure != null) {
                    assert (false);
                    return;
                }
                keyConfigurationStructure = child;
            }
            if (keyConfigurationStructure == null) {
                assert (false);
                return;
            }
            String keyCellLabel = keyConfigurationStructure.id;
            this.context.cellDataStructures.put(mapCellLabel, new CellMap(mapCellLabel, entryCellLabel, keyCellLabel));
        }
    }
}

