/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.compile.transformers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.kframework.kil.ASTNode;
import org.kframework.kil.Module;
import org.kframework.kil.ModuleItem;
import org.kframework.kil.Production;
import org.kframework.kil.Sort;
import org.kframework.kil.UserList;
import org.kframework.kil.loader.AddConsesVisitor;
import org.kframework.kil.loader.CollectConsesVisitor;
import org.kframework.kil.loader.Context;
import org.kframework.kil.visitors.CopyOnWriteTransformer;
import org.kframework.kil.visitors.exceptions.TransformerException;

public class CompleteSortLatice
extends CopyOnWriteTransformer {
    public static final String LIST_OF_BOTTOM_PREFIX = "#ListOf";
    public static final String BOTTOM_SORT_NAME = "#Bot";

    public CompleteSortLatice(Context context) {
        super("Subsort syntactic lists", context);
    }

    public static String getUserListName(String sort, String separator) {
        return LIST_OF_BOTTOM_PREFIX + sort + "{\"" + separator + "\"}";
    }

    @Override
    public ASTNode transform(Module node) throws TransformerException {
        UserList userList;
        UserList userList1;
        boolean change;
        Module transformedNode = node.shallowCopy();
        transformedNode.setItems(new ArrayList<ModuleItem>(node.getItems()));
        HashSet<String> separators = new HashSet<String>();
        for (Production production : this.context.listConses.values()) {
            UserList userList2 = (UserList)production.getItems().get(0);
            separators.add(userList2.getSeparator());
        }
        transformedNode.addProduction(BOTTOM_SORT_NAME, new Production(new Sort(BOTTOM_SORT_NAME), Collections.emptyList()));
        for (String separator : separators) {
            transformedNode.addProduction(CompleteSortLatice.getUserListName(BOTTOM_SORT_NAME, separator), new UserList(BOTTOM_SORT_NAME, separator));
        }
        do {
            change = false;
            block3: for (String sort1 : node.getAllSorts()) {
                Collection<Production> productions = node.getProductionsOf(sort1);
                if (productions.isEmpty()) continue;
                for (Production production : productions) {
                    if (production.isSubsort()) continue;
                    continue block3;
                }
                block5: for (String sort2 : node.getAllSorts()) {
                    if (this.context.isSubsortedEq(sort2, sort1) || this.context.isSubsortedEq(sort1, sort2) || this.context.isListSort(sort2)) continue;
                    for (Production production : productions) {
                        if (this.context.isSubsorted(sort2, production.getChildSort(0))) continue;
                        continue block5;
                    }
                    transformedNode.addSubsort(sort2, sort1, this.context);
                    change = true;
                }
            }
            this.context.finalizeSubsorts();
        } while (change);
        for (Production production1 : this.context.listConses.values()) {
            userList1 = (UserList)production1.getItems().get(0);
            HashSet<String> subsorts = new HashSet<String>();
            for (Production production2 : this.context.listConses.values()) {
                UserList userList2 = (UserList)production2.getItems().get(0);
                if (!userList1.getSeparator().equals(userList2.getSeparator()) || !this.context.isSubsorted(userList1.getSort(), userList2.getSort())) continue;
                subsorts.add(userList2.getSort());
            }
            for (String sort : node.getAllSorts()) {
                if (subsorts.contains(sort) || !this.context.isSubsorted(userList1.getSort(), sort)) continue;
                transformedNode.addProduction(CompleteSortLatice.getUserListName(sort, userList1.getSeparator()), new UserList(sort, userList1.getSeparator()));
            }
        }
        transformedNode.accept(new AddConsesVisitor(this.context));
        transformedNode.accept(new CollectConsesVisitor(this.context));
        for (Production production1 : this.context.listConses.values()) {
            userList1 = (UserList)production1.getItems().get(0);
            for (Production production2 : this.context.listConses.values()) {
                UserList userList2 = (UserList)production2.getItems().get(0);
                if (!userList1.getSeparator().equals(userList2.getSeparator()) || !this.context.isSubsorted(userList1.getSort(), userList2.getSort())) continue;
                transformedNode.addSubsort(production1.getSort(), production2.getSort(), this.context);
            }
        }
        for (Production production : this.context.listConses.values()) {
            userList = (UserList)production.getItems().get(0);
            if (userList.getSort().equals(BOTTOM_SORT_NAME)) continue;
            transformedNode.addSubsort(production.getSort(), CompleteSortLatice.getUserListName(BOTTOM_SORT_NAME, userList.getSeparator()), this.context);
        }
        for (Production production : this.context.listConses.values()) {
            userList = (UserList)production.getItems().get(0);
            if (!this.context.isSubsorted("KResult", userList.getSort())) continue;
            transformedNode.addSubsort("KResult", production.getSort(), this.context);
        }
        if (transformedNode.getItems().size() != node.getItems().size()) {
            return transformedNode;
        }
        return node;
    }
}

