/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.compile.transformers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.kframework.compile.transformers.ResolveAnonymousVariables;
import org.kframework.compile.utils.MetaK;
import org.kframework.compile.utils.Substitution;
import org.kframework.kil.ASTNode;
import org.kframework.kil.Configuration;
import org.kframework.kil.Context;
import org.kframework.kil.Freezer;
import org.kframework.kil.FreezerHole;
import org.kframework.kil.Hole;
import org.kframework.kil.KSequence;
import org.kframework.kil.Module;
import org.kframework.kil.ModuleItem;
import org.kframework.kil.Rewrite;
import org.kframework.kil.Rule;
import org.kframework.kil.Syntax;
import org.kframework.kil.Term;
import org.kframework.kil.TermCons;
import org.kframework.kil.Variable;
import org.kframework.kil.visitors.CopyOnWriteTransformer;
import org.kframework.kil.visitors.exceptions.TransformerException;
import org.kframework.utils.errorsystem.KException;
import org.kframework.utils.general.GlobalSettings;

public class ContextsToHeating
extends CopyOnWriteTransformer {
    private List<ModuleItem> rules = new ArrayList<ModuleItem>();

    public ContextsToHeating(org.kframework.kil.loader.Context context) {
        super("Contexts to Heating Rules", context);
    }

    @Override
    public ASTNode transform(Module node) throws TransformerException {
        return ((Module)super.transform(node)).addModuleItems(this.rules);
    }

    private List<Term> splitRewrite(Term term) throws TransformerException {
        Variable v;
        if (GlobalSettings.javaBackend) {
            if (GlobalSettings.testgen) {
                if (term instanceof TermCons) {
                    TermCons termCons = (TermCons)term;
                    int index = 0;
                    for (int i = 0; i < termCons.arity(); ++i) {
                        if (!termCons.getContents().get(i).getSort().equals("KItem")) continue;
                        index = i;
                        break;
                    }
                    v = Variable.getFreshVar(termCons.getProduction().getChildSort(index));
                } else {
                    v = Variable.getFreshVar(term.getSort());
                }
            } else {
                v = Variable.getFreshVar("KItem");
            }
        } else {
            v = Variable.getFreshVar("K");
        }
        final ArrayList<Term> list = new ArrayList<Term>();
        CopyOnWriteTransformer transformer = new CopyOnWriteTransformer("splitter", this.context){

            @Override
            public ASTNode transform(Rewrite rewrite) {
                list.add(rewrite.getLeft());
                list.add(rewrite.getRight());
                return v;
            }
        };
        Term result = (Term)term.accept(transformer);
        list.add(0, v);
        list.add(0, result);
        return list;
    }

    private Term substituteHole(Term term, Term replacement) throws TransformerException {
        return this.substituteSubstitutable(term, Hole.KITEM_HOLE, replacement);
    }

    public Term freeze(Term term) {
        try {
            return new Freezer(this.substituteHole(term, new FreezerHole(0)));
        }
        catch (TransformerException e) {
            e.printStackTrace();
            return null;
        }
    }

    private Term substituteVariable(Term term, Variable variable, Term replacement) throws TransformerException {
        return this.substituteSubstitutable(term, variable, replacement);
    }

    private Term substituteSubstitutable(Term term, Term variable, Term replacement) throws TransformerException {
        HashMap<Term, Term> hashMap = new HashMap<Term, Term>();
        hashMap.put(variable, replacement);
        Substitution substitution = new Substitution(hashMap, this.context);
        if (term == null) {
            return null;
        }
        return (Term)term.accept(substitution);
    }

    @Override
    public ASTNode transform(Context node) throws TransformerException {
        Integer countRewrites;
        Term body = (Term)node.getBody().accept(new ResolveAnonymousVariables(this.context));
        int countHoles = MetaK.countHoles(body, this.context);
        if (countHoles == 0) {
            GlobalSettings.kem.register(new KException(KException.ExceptionType.ERROR, KException.KExceptionGroup.CRITICAL, "Contexts must have at least one HOLE.", this.getName(), node.getLocation(), node.getFilename()));
        }
        if ((countRewrites = Integer.valueOf(MetaK.countRewrites(body, this.context))) > 1) {
            GlobalSettings.kem.register(new KException(KException.ExceptionType.ERROR, KException.KExceptionGroup.CRITICAL, "Contexts can contain at most one rewrite", this.getName(), node.getLocation(), node.getFilename()));
        } else if (countRewrites == 0) {
            body = this.substituteHole(body, new Rewrite(Hole.KITEM_HOLE, Hole.KITEM_HOLE, this.context));
        }
        List<Term> r = this.splitRewrite(body);
        Term rewriteContext = r.get(0);
        Variable freshVariable = (Variable)r.get(1);
        Term left = r.get(2);
        Term right = r.get(3);
        if (!(left instanceof Hole)) {
            GlobalSettings.kem.register(new KException(KException.ExceptionType.ERROR, KException.KExceptionGroup.CRITICAL, "Only the HOLE can be rewritten in a context definition", this.getName(), node.getLocation(), node.getFilename()));
        }
        Term lhsHeat = rewriteContext;
        ArrayList<Term> rewriteList = new ArrayList<Term>();
        rewriteList.add(this.substituteHole(right, freshVariable));
        rewriteList.add(new Freezer(this.substituteVariable(rewriteContext, freshVariable, new FreezerHole(0))));
        KSequence rhsHeat = new KSequence(rewriteList);
        Rule heatingRule = new Rule(lhsHeat, rhsHeat, this.context);
        heatingRule.setRequires(this.substituteHole(node.getRequires(), freshVariable));
        heatingRule.setEnsures(this.substituteHole(node.getEnsures(), freshVariable));
        heatingRule.getAttributes().getContents().addAll(node.getAttributes().getContents());
        heatingRule.putAttribute("heat", "");
        if (GlobalSettings.testgen) {
            for (int i = 0; i < ((TermCons)body).getContents().size(); ++i) {
                if (!(((TermCons)body).getContents().get(i) instanceof Rewrite)) continue;
                heatingRule.setLabel("heat(" + node.getAttribute("klabel") + "," + i + ")");
                break;
            }
        }
        this.rules.add(heatingRule);
        Rule coolingRule = new Rule(rhsHeat, lhsHeat, this.context);
        coolingRule.getAttributes().getContents().addAll(node.getAttributes().getContents());
        coolingRule.putAttribute("cool", "");
        if (GlobalSettings.testgen) {
            for (int i = 0; i < ((TermCons)body).getContents().size(); ++i) {
                if (!(((TermCons)body).getContents().get(i) instanceof Rewrite)) continue;
                coolingRule.setLabel("cool(" + node.getAttribute("klabel") + "," + i + ")");
                break;
            }
        }
        this.rules.add(coolingRule);
        return null;
    }

    @Override
    public ASTNode transform(Syntax node) {
        return node;
    }

    @Override
    public ASTNode transform(Rule node) {
        return node;
    }

    @Override
    public ASTNode transform(Configuration node) {
        return node;
    }
}

