/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.compile.transformers;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.kframework.compile.utils.KilProperty;
import org.kframework.kil.ASTNode;
import org.kframework.kil.BuiltinLookup;
import org.kframework.kil.KSort;
import org.kframework.kil.ListBuiltin;
import org.kframework.kil.ListLookup;
import org.kframework.kil.ListUpdate;
import org.kframework.kil.MapBuiltin;
import org.kframework.kil.MapLookup;
import org.kframework.kil.MapUpdate;
import org.kframework.kil.Rewrite;
import org.kframework.kil.Rule;
import org.kframework.kil.SetBuiltin;
import org.kframework.kil.SetLookup;
import org.kframework.kil.SetUpdate;
import org.kframework.kil.Term;
import org.kframework.kil.Variable;
import org.kframework.kil.loader.Context;
import org.kframework.kil.visitors.CopyOnWriteTransformer;
import org.kframework.kil.visitors.exceptions.TransformerException;
import org.kframework.utils.errorsystem.KException;
import org.kframework.utils.general.GlobalSettings;

@KilProperty.Requires(value={KilProperty.TOP_REWRITING, KilProperty.COMPILED_DATA_STRUCTURES})
@KilProperty.Ensures(value={KilProperty.NO_DATA_STRUCTURE_PATTERN_MATCHING})
public class DataStructureToLookupUpdate
extends CopyOnWriteTransformer {
    private Map<Variable, Term> reverseMap = new HashMap<Variable, Term>();
    private Map<Variable, Integer> concreteSize = new HashMap<Variable, Integer>();
    private ArrayList<VariableCache> queue = new ArrayList();
    private Status status;

    private void registerError(Rule node, String message) {
        GlobalSettings.kem.register(new KException(KException.ExceptionType.ERROR, KException.KExceptionGroup.CRITICAL, message, node.getFilename(), node.getLocation()));
    }

    public DataStructureToLookupUpdate(Context context) {
        super("Compile maps into load and store operations", context);
    }

    @Override
    public ASTNode transform(Rule node) throws TransformerException {
        SetLookup setLookup;
        MapLookup mapLookup;
        int i;
        boolean change;
        assert (node.getBody() instanceof Rewrite) : "expected rewrite at the top of rule " + node + ". " + "DataStructureToLookupUpdate pass should be applied after ResolveRewrite pass.";
        this.reverseMap.clear();
        this.concreteSize.clear();
        this.queue.clear();
        Rewrite rewrite = (Rewrite)node.getBody();
        this.status = Status.LHS;
        Term lhs = (Term)rewrite.getLeft().accept(this);
        this.status = Status.RHS;
        Term rhs = (Term)rewrite.getRight().accept(this);
        this.status = Status.CONDITION;
        Term requires = node.getRequires() != null ? (Term)node.getRequires().accept(this) : null;
        Term ensures = node.getEnsures();
        if (lhs == rewrite.getLeft() && rhs == rewrite.getRight() && requires == node.getRequires() && ensures == node.getEnsures()) {
            return node;
        }
        HashSet<Variable> variables = new HashSet<Variable>(lhs.variables());
        if (requires != null) {
            variables.addAll(requires.variables());
        }
        ArrayList<BuiltinLookup> lookups = new ArrayList<BuiltinLookup>(node.getLookups());
        for (VariableCache item : this.queue) {
            item.unmatchedVariables().removeAll(lhs.variables());
        }
        do {
            change = false;
            for (i = 0; i < this.queue.size(); ++i) {
                if (!this.queue.get(i).unmatchedVariables().isEmpty()) continue;
                change = true;
                BuiltinLookup lookup = (BuiltinLookup)((Object)this.queue.remove(i));
                --i;
                for (VariableCache item : this.queue) {
                    item.unmatchedVariables().removeAll(lookup.variables());
                }
                variables.addAll(lookup.variables());
                if (lookup instanceof ListLookup) {
                    ListLookup listLookup = (ListLookup)lookup;
                    lookups.add(new ListLookup(listLookup.base(), listLookup.key(), listLookup.value(), listLookup.kind()));
                    continue;
                }
                if (lookup instanceof MapLookup) {
                    mapLookup = (MapLookup)lookup;
                    lookups.add(new MapLookup(mapLookup.base(), mapLookup.key(), mapLookup.value(), mapLookup.kind(), false));
                    continue;
                }
                if (lookup instanceof SetLookup) {
                    setLookup = (SetLookup)lookup;
                    lookups.add(new SetLookup(setLookup.base(), setLookup.key(), false));
                    continue;
                }
                assert (false) : "unexpected builtin data structure type";
            }
        } while (change);
        for (i = 0; i < this.queue.size(); ++i) {
            for (int j = i + 1; j < this.queue.size(); ++j) {
                Sets.SetView<Variable> commonVariables = Sets.intersection(((BuiltinLookup)((Object)this.queue.get(i))).variables(), ((BuiltinLookup)((Object)this.queue.get(j))).variables());
                if (commonVariables.isEmpty()) continue;
                this.registerError(node, "Unsupported map pattern in the rule left-hand side");
                return null;
            }
        }
        for (i = 0; i < this.queue.size(); ++i) {
            BuiltinLookup lookup = (BuiltinLookup)((Object)this.queue.get(i));
            if (lookup instanceof MapLookup) {
                mapLookup = (MapLookup)lookup;
                if (mapLookup.key() instanceof Variable && !variables.contains(mapLookup.key()) && mapLookup.value() instanceof Variable && !variables.contains(mapLookup.value())) {
                    lookups.add(new MapLookup(mapLookup.base(), mapLookup.key(), mapLookup.value(), mapLookup.kind(), true));
                    continue;
                }
                this.registerError(node, "Unsupported map pattern in the rule left-hand side");
                return null;
            }
            if (lookup instanceof SetLookup) {
                setLookup = (SetLookup)lookup;
                if (setLookup.key() instanceof Variable && !variables.contains(setLookup.key())) {
                    lookups.add(new SetLookup(setLookup.base(), setLookup.key(), true));
                    continue;
                }
                this.registerError(node, "Unsupported map pattern in the rule left-hand side");
                return null;
            }
            assert (false) : "unexpected builtin data structure type";
        }
        Rule returnNode = node.shallowCopy();
        rewrite = rewrite.shallowCopy();
        rewrite.setLeft(lhs, this.context);
        rewrite.setRight(rhs, this.context);
        returnNode.setBody(rewrite);
        returnNode.setRequires(requires);
        returnNode.setEnsures(ensures);
        returnNode.setLookups(lookups);
        returnNode.setConcreteDataStructureSize(new HashMap<Variable, Integer>(returnNode.getConcreteDataStructureSize()));
        returnNode.getConcreteDataStructureSize().putAll(this.concreteSize);
        return returnNode;
    }

    @Override
    public ASTNode transform(ListBuiltin node) throws TransformerException {
        node = (ListBuiltin)super.transform(node);
        if (this.status == Status.LHS) {
            assert (node.isLHSView());
            if (node.elementsLeft().isEmpty() && node.elementsRight().isEmpty() && node.hasViewBase()) {
                return node.viewBase();
            }
            Variable variable = Variable.getFreshVar(node.sort().name());
            if (node.hasViewBase()) {
                assert (!this.reverseMap.containsKey(node.viewBase()));
                this.reverseMap.put(node.viewBase(), new ListUpdate(variable, node.elementsLeft(), node.elementsRight()));
            } else {
                this.concreteSize.put(variable, node.elementsLeft().size() + node.elementsRight().size());
            }
            int key = 0;
            for (Term term : node.elementsLeft()) {
                this.queue.add(new ExtendedListLookup(variable, key, term, KSort.getKSort(term.getSort())));
                ++key;
            }
            key = -node.elementsRight().size();
            for (Term term : node.elementsRight()) {
                this.queue.add(new ExtendedListLookup(variable, key, term, KSort.getKSort(term.getSort())));
                ++key;
            }
            return variable;
        }
        ArrayList<Term> baseTerms = new ArrayList<Term>();
        ArrayList<Term> elementsLeft = new ArrayList<Term>(node.elementsLeft());
        ArrayList<Term> elementsRight = new ArrayList<Term>(node.elementsRight());
        for (Term term : node.baseTerms()) {
            if (!(term instanceof ListUpdate)) {
                baseTerms.add(term);
                continue;
            }
            ListUpdate listUpdate = (ListUpdate)term;
            ArrayList<Term> removeLeft = new ArrayList<Term>(listUpdate.removeLeft());
            ArrayList<Term> removeRight = new ArrayList<Term>(listUpdate.removeRight());
            ListIterator iteratorElem = elementsLeft.listIterator(elementsLeft.size());
            ListIterator iteratorRemove = removeLeft.listIterator(removeLeft.size());
            while (iteratorElem.hasPrevious() && iteratorRemove.hasPrevious() && ((Term)iteratorElem.previous()).equals(iteratorRemove.previous())) {
                iteratorElem.remove();
                iteratorRemove.remove();
            }
            iteratorElem = elementsRight.listIterator();
            iteratorRemove = removeRight.listIterator();
            while (iteratorElem.hasNext() && iteratorRemove.hasNext() && ((Term)iteratorElem.next()).equals(iteratorRemove.next())) {
                iteratorElem.remove();
                iteratorRemove.remove();
            }
            if (removeLeft.isEmpty() && removeRight.isEmpty()) {
                baseTerms.add(listUpdate.base());
                continue;
            }
            baseTerms.add(new ListUpdate(listUpdate.base(), removeLeft, removeRight));
        }
        if (baseTerms.size() == 1 && elementsLeft.isEmpty() && elementsRight.isEmpty()) {
            return (ASTNode)baseTerms.get(0);
        }
        return ListBuiltin.of(node.sort(), elementsLeft, elementsRight, baseTerms);
    }

    @Override
    public ASTNode transform(MapBuiltin node) throws TransformerException {
        node = (MapBuiltin)super.transform(node);
        if (this.status == Status.LHS) {
            assert (node.isLHSView());
            if (node.elements().isEmpty() && node.hasViewBase()) {
                return node.viewBase();
            }
            Variable variable = Variable.getFreshVar(node.sort().name());
            if (node.hasViewBase()) {
                assert (!this.reverseMap.containsKey(node.viewBase()));
                this.reverseMap.put(node.viewBase(), new MapUpdate(variable, node.elements(), Collections.emptyMap()));
            } else {
                this.concreteSize.put(variable, node.elements().size());
            }
            for (Map.Entry<Term, Term> entry : node.elements().entrySet()) {
                this.queue.add(new ExtendedMapLookup(variable, entry.getKey(), entry.getValue(), KSort.getKSort(entry.getValue().getSort())));
            }
            return variable;
        }
        ArrayList<Term> baseTerms = new ArrayList<Term>();
        HashMap<Term, Term> elements = new HashMap<Term, Term>(node.elements());
        for (Term term : node.baseTerms()) {
            if (!(term instanceof MapUpdate)) {
                baseTerms.add(term);
                continue;
            }
            MapUpdate mapUpdate = (MapUpdate)term;
            HashMap<Term, Term> removeEntries = new HashMap<Term, Term>();
            HashMap<Term, Term> updateEntries = new HashMap<Term, Term>();
            for (Map.Entry<Term, Term> entry : mapUpdate.removeEntries().entrySet()) {
                if (elements.containsKey(entry.getKey())) {
                    if (((Term)elements.get(entry.getKey())).equals(entry.getValue())) {
                        elements.remove(entry.getKey());
                        continue;
                    }
                    updateEntries.put(entry.getKey(), (Term)elements.remove(entry.getKey()));
                    continue;
                }
                removeEntries.put(entry.getKey(), entry.getValue());
            }
            if (removeEntries.isEmpty() && updateEntries.isEmpty()) {
                baseTerms.add(mapUpdate.map());
                continue;
            }
            baseTerms.add(new MapUpdate(mapUpdate.map(), removeEntries, updateEntries));
        }
        if (baseTerms.size() == 1 && elements.isEmpty()) {
            return (ASTNode)baseTerms.get(0);
        }
        return new MapBuiltin(node.sort(), baseTerms, elements);
    }

    @Override
    public ASTNode transform(SetBuiltin node) throws TransformerException {
        node = (SetBuiltin)super.transform(node);
        if (this.status == Status.LHS) {
            assert (node.isLHSView());
            if (node.elements().isEmpty() && node.hasViewBase()) {
                return node.viewBase();
            }
            Variable variable = Variable.getFreshVar(node.sort().name());
            if (node.hasViewBase()) {
                assert (!this.reverseMap.containsKey(node.viewBase()));
                this.reverseMap.put(node.viewBase(), new SetUpdate(variable, node.elements()));
            } else {
                this.concreteSize.put(variable, node.elements().size());
            }
            for (Term term : node.elements()) {
                this.queue.add(new ExtendedSetLookup(variable, term));
            }
            return variable;
        }
        ArrayList<Term> baseTerms = new ArrayList<Term>();
        ArrayList<Term> elements = new ArrayList<Term>(node.elements());
        for (Term term : node.baseTerms()) {
            if (!(term instanceof SetUpdate)) {
                baseTerms.add(term);
                continue;
            }
            SetUpdate setUpdate = (SetUpdate)term;
            ArrayList<Term> removeEntries = new ArrayList<Term>();
            for (Term key : setUpdate.removeEntries()) {
                if (elements.contains(key)) {
                    elements.remove(key);
                    continue;
                }
                removeEntries.add(key);
            }
            if (removeEntries.isEmpty()) {
                baseTerms.add(setUpdate.set());
                continue;
            }
            baseTerms.add(new SetUpdate(setUpdate.set(), removeEntries));
        }
        if (baseTerms.size() == 1 && elements.isEmpty()) {
            return (ASTNode)baseTerms.get(0);
        }
        return new SetBuiltin(node.sort(), baseTerms, elements);
    }

    @Override
    public ASTNode transform(Variable node) throws TransformerException {
        if (this.status != Status.LHS && this.reverseMap.containsKey(node)) {
            return this.reverseMap.get(node);
        }
        return node;
    }

    private static enum Status {
        LHS,
        RHS,
        CONDITION;

    }

    private class ExtendedSetLookup
    extends SetLookup
    implements VariableCache {
        private Set<Variable> variables;

        ExtendedSetLookup(Variable set, Term key) {
            super(set, key, false);
            this.variables = new HashSet<Variable>();
            this.variables.add(set);
            this.variables.addAll(key.variables());
        }

        @Override
        public Set<Variable> unmatchedVariables() {
            return this.variables;
        }
    }

    private class ExtendedMapLookup
    extends MapLookup
    implements VariableCache {
        private Set<Variable> variables;

        ExtendedMapLookup(Variable map, Term key, Term value, KSort kind) {
            super(map, key, value, kind, false);
            this.variables = new HashSet<Variable>();
            this.variables.add(map);
            this.variables.addAll(key.variables());
        }

        @Override
        public Set<Variable> unmatchedVariables() {
            return this.variables;
        }
    }

    private class ExtendedListLookup
    extends ListLookup
    implements VariableCache {
        private Set<Variable> variables;

        ExtendedListLookup(Variable list, int key, Term value, KSort kind) {
            super(list, key, value, kind);
            this.variables = new HashSet<Variable>();
            this.variables.add(list);
        }

        @Override
        public Set<Variable> unmatchedVariables() {
            return this.variables;
        }
    }

    private static interface VariableCache {
        public Set<Variable> unmatchedVariables();
    }
}

