/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.compile.transformers;

import java.util.List;
import java.util.Set;
import org.kframework.kil.ASTNode;
import org.kframework.kil.KApp;
import org.kframework.kil.KLabelConstant;
import org.kframework.kil.Production;
import org.kframework.kil.Rewrite;
import org.kframework.kil.Rule;
import org.kframework.kil.Term;
import org.kframework.kil.TermCons;
import org.kframework.kil.loader.Context;
import org.kframework.kil.visitors.CopyOnWriteTransformer;
import org.kframework.kil.visitors.exceptions.TransformerException;

public class DeleteFunctionRules
extends CopyOnWriteTransformer {
    private final Set<String> hooks;

    public DeleteFunctionRules(Set<String> hooks, Context context) {
        super("Delete function rules for given function symbols", context);
        this.hooks = hooks;
    }

    @Override
    public ASTNode transform(Rule node) throws TransformerException {
        Term body = node.getBody();
        if (body instanceof Rewrite) {
            body = ((Rewrite)body).getLeft();
        }
        ASTNode prod = null;
        if (body instanceof TermCons) {
            prod = (Production)this.context.conses.get(((TermCons)body).getCons());
        } else if (body instanceof KApp) {
            Term l = ((KApp)body).getLabel();
            if (!(l instanceof KLabelConstant)) {
                return node;
            }
            String label = ((KLabelConstant)l).getLabel();
            List<Production> prods = this.context.productionsOf(label);
            if (prods.size() != 1) {
                return node;
            }
            prod = prods.get(0);
        }
        if (prod == null || !prod.containsAttribute("hook")) {
            return node;
        }
        String hook = prod.getAttribute("hook");
        if (!this.hooks.contains(hook)) {
            return node;
        }
        if (node.containsAttribute("simplification")) {
            return node;
        }
        return null;
    }
}

