/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.compile.transformers;

import java.util.ArrayList;
import org.kframework.kil.ASTNode;
import org.kframework.kil.Cell;
import org.kframework.kil.Context;
import org.kframework.kil.DataStructureSort;
import org.kframework.kil.IntBuiltin;
import org.kframework.kil.KApp;
import org.kframework.kil.KLabelConstant;
import org.kframework.kil.List;
import org.kframework.kil.ListItem;
import org.kframework.kil.Rule;
import org.kframework.kil.StringBuiltin;
import org.kframework.kil.Syntax;
import org.kframework.kil.Term;
import org.kframework.kil.TermCons;
import org.kframework.kil.Variable;
import org.kframework.kil.visitors.CopyOnWriteTransformer;
import org.kframework.kil.visitors.exceptions.TransformerException;
import org.kframework.utils.errorsystem.KException;
import org.kframework.utils.general.GlobalSettings;

public class DesugarStreams
extends CopyOnWriteTransformer {
    ArrayList<String> channels = new ArrayList();
    boolean newList;

    public DesugarStreams(org.kframework.kil.loader.Context context, boolean newList) {
        super("Desugar streams", context);
        this.channels.add("stdin");
        this.channels.add("stdout");
        this.newList = newList;
    }

    @Override
    public ASTNode transform(Cell node) throws TransformerException {
        Cell cell;
        String stream;
        ASTNode result = super.transform(node);
        if (!(result instanceof Cell)) {
            GlobalSettings.kem.register(new KException(KException.ExceptionType.ERROR, KException.KExceptionGroup.INTERNAL, "Expecting Cell, but got " + result.getClass() + " in Streams Desugarer.", this.getName(), result.getFilename(), result.getLocation()));
        }
        if (null == (stream = (cell = (Cell)result).getCellAttributes().get("stream"))) {
            return cell;
        }
        node = result == node ? node.shallowCopy() : cell;
        node.setContents(this.makeStreamList(stream, node));
        return node;
    }

    private Term makeStreamList(String stream, Cell node) {
        List result;
        Term contents = node.getContents();
        Term addAtBeginning = null;
        Term addAtEnd = null;
        if (this.newList) {
            result = null;
        } else if (contents instanceof List) {
            result = ((List)contents).shallowCopy();
        } else {
            result = new List();
            result.getContents().add(contents);
        }
        ArrayList<Term> items = new ArrayList<Term>();
        if ("stdin".equals(stream)) {
            if (!this.newList) {
                items.addAll(result.getContents());
            } else {
                addAtBeginning = contents;
            }
            TermCons buffer = new TermCons("Stream", "Stream1IOBufferSyn", this.context);
            ArrayList<Term> bufferTerms = new ArrayList<Term>();
            bufferTerms.add(new Variable("$stdin", "String"));
            buffer.setContents(bufferTerms);
            items.add(this.newListItem(buffer));
            items.add(new Variable("$noIO", !this.newList ? "ListItem" : "MyList"));
            TermCons stdinStream = new TermCons("Stream", "Stream1InputStreamSyn", this.context);
            ArrayList<Term> stdinStreamTerms = new ArrayList<Term>();
            stdinStreamTerms.add(IntBuiltin.ZERO);
            stdinStream.setContents(stdinStreamTerms);
            items.add(this.newListItem(stdinStream));
        }
        if ("stdout".equals(stream)) {
            TermCons stdoutStream = new TermCons("Stream", "Stream1OutputStreamSyn", this.context);
            ArrayList<Term> stdinStreamTerms = new ArrayList<Term>();
            stdinStreamTerms.add(IntBuiltin.ONE);
            stdoutStream.setContents(stdinStreamTerms);
            items.add(this.newListItem(stdoutStream));
            items.add(new Variable("$noIO", !this.newList ? "ListItem" : "MyList"));
            TermCons buffer = new TermCons("Stream", "Stream1IOBufferSyn", this.context);
            ArrayList<Term> bufferTerms = new ArrayList<Term>();
            bufferTerms.add(StringBuiltin.EMPTY);
            buffer.setContents(bufferTerms);
            items.add(this.newListItem(buffer));
            if (!this.newList) {
                items.addAll(result.getContents());
            } else {
                addAtEnd = contents;
            }
        }
        if (this.channels.indexOf(stream) == -1) {
            GlobalSettings.kem.register(new KException(KException.ExceptionType.ERROR, KException.KExceptionGroup.INTERNAL, "Make sure you give the correct stream names: " + this.channels.toString(), this.getName(), node.getFilename(), node.getLocation()));
        }
        if (this.newList) {
            DataStructureSort myList = this.context.dataStructureListSortOf("MyList");
            Term newItems = DataStructureSort.listOf(this.context, items.toArray(new Term[0]));
            if (addAtBeginning != null) {
                newItems = KApp.of(KLabelConstant.of(myList.constructorLabel(), this.context), addAtBeginning, newItems);
            }
            if (addAtEnd != null) {
                newItems = KApp.of(KLabelConstant.of(myList.constructorLabel(), this.context), newItems, addAtEnd);
            }
            return newItems;
        }
        result.setContents(items);
        return result;
    }

    private Term newListItem(Term element) {
        if (this.newList) {
            DataStructureSort myList = this.context.dataStructureListSortOf("MyList");
            return KApp.of(KLabelConstant.of(myList.elementLabel(), this.context), element);
        }
        return new ListItem(element);
    }

    @Override
    public ASTNode transform(Context node) {
        return node;
    }

    @Override
    public ASTNode transform(Rule node) {
        return node;
    }

    @Override
    public ASTNode transform(Syntax node) {
        return node;
    }
}

